package com.iplatform.base.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "iplatform.security.user")
public class SecurityUserProperties {

    /**
     * 用户修改密码的安全等级，参考：{@linkplain com.walker.infrastructure.utils.PasswordUtils#LEVEL_01_LOW}
     * @return
     * @date 2023-08-03
     */
    public int getPassLevel() {
        return passLevel;
    }

    public void setPassLevel(int passLevel) {
        this.passLevel = passLevel;
    }

    /**
     * 是否要（强制提示）修改默认密码
     * @return
     * @date 2023-08-03
     */
    public boolean isPassDefaultModify() {
        return passDefaultModify;
    }

    public void setPassDefaultModify(boolean passDefaultModify) {
        this.passDefaultModify = passDefaultModify;
    }

    private int passLevel = 1;
    private boolean passDefaultModify = true;
}
