package com.iplatform.base.config;

import com.iplatform.base.FileOperateSpi;
import com.iplatform.base.SecuritySpi;
import com.iplatform.core.PlatformConfiguration;
import com.walker.infrastructure.utils.ClassUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Constructor;

/**
 * SecuritySPI实现配置对象，虽然是在基础模块配置，但实现可以通过引入各种第三方来实现。<p></p>
 * 如：spring security 或者 shiro等，默认: sepring security。
 * @date 2022-11-11
 * @author 时克英
 */
@Configuration
public class SpiConfig extends PlatformConfiguration {

    private final String DEFAULT_SECURITY_SPI_CLASS = "com.iplatform.security.DefaultSecuritySpi";
    private final String NOTHING_SECURITY_SPI_CLASS = "com.iplatform.base.support.NothingSecuritySpi";

    private final String DEFAULT_FILE_OPERATE_SPI_CLASS = "com.iplatform.file.DefaultFileOperateSpi";

    /**
     * 文件基本信息配置，放在 Base spi 模块配置，可让 file 模块复用。
     * @return
     * @date 2023-02-15
     */
    @Bean
    public FileProperties fileProperties(){
        return new FileProperties();
    }

    @Bean
    public FileOperateSpi fileOperateSpi(){
        try {
            FileOperateSpi fileOperateSpi = this.acquireFileOperateSpi(DEFAULT_FILE_OPERATE_SPI_CLASS);
            logger.info("创建 'FileOperateSpi' 实现对象成功: " + DEFAULT_FILE_OPERATE_SPI_CLASS);
            return fileOperateSpi;

        } catch (Exception e) {
            if(e instanceof ClassNotFoundException){
                logger.error("创建'FileOperateSpi'提供者对象错误, 实现类不存在: " + DEFAULT_FILE_OPERATE_SPI_CLASS);
            }
            throw new RuntimeException("创建 'FileOperateSpi' 异常: " + DEFAULT_FILE_OPERATE_SPI_CLASS, e);
        }
    }

    @Bean
    public SecuritySpi securitySpi(){
        try {
//            Class<?> schedulerClass = ClassUtils.forName(DEFAULT_SECURITY_SPI_CLASS, SpiConfig.class.getClassLoader());
//            Constructor<SecuritySpi> constructor = (Constructor<SecuritySpi>)schedulerClass.getConstructor();
//            SecuritySpi securitySpi = constructor.newInstance();
            SecuritySpi securitySpi = this.acquireSecuritySpi(DEFAULT_SECURITY_SPI_CLASS);
            logger.info("创建 SecuritySpi 实现对象成功: " + DEFAULT_SECURITY_SPI_CLASS);
            return securitySpi;

        } catch (Exception e) {
            if(e instanceof ClassNotFoundException){
                logger.error("创建'SecuritySpi'提供者对象错误, 实现类不存在: " + DEFAULT_SECURITY_SPI_CLASS);
                logger.warn("创建内置默认SPI: " + NOTHING_SECURITY_SPI_CLASS);
                try {
                    return this.acquireSecuritySpi(NOTHING_SECURITY_SPI_CLASS);
                } catch (Exception ex) {
                    logger.error(".............", ex);
                    throw new RuntimeException("创建内置SPI异常: " + NOTHING_SECURITY_SPI_CLASS, ex);
                }
            } else {
                throw new RuntimeException("创建SPI异常:" + e.getMessage(), e);
            }
        }
//        catch (NoSuchMethodException e) {
//            logger.error("创建'SecuritySpi'提供者对象错误, 默认构造方法不存在", e);
//            throw new RuntimeException(e);
//        } catch (Exception ex){
//            throw new RuntimeException(ex);
//        }
    }

    private FileOperateSpi acquireFileOperateSpi(String clazzName) throws Exception{
        Class<?> schedulerClass = ClassUtils.forName(clazzName, SpiConfig.class.getClassLoader());
        Constructor<FileOperateSpi> constructor = (Constructor<FileOperateSpi>)schedulerClass.getConstructor();
        FileOperateSpi securitySpi = constructor.newInstance();
        return securitySpi;
    }

    private SecuritySpi acquireSecuritySpi(String clazzName) throws Exception{
        Class<?> schedulerClass = ClassUtils.forName(clazzName, SpiConfig.class.getClassLoader());
        Constructor<SecuritySpi> constructor = (Constructor<SecuritySpi>)schedulerClass.getConstructor();
        SecuritySpi securitySpi = constructor.newInstance();
        return securitySpi;
    }

}
