package com.iplatform.base.config;

import com.iplatform.base.Constants;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "iplatform.tcp")
public class TcpProperties {

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isShowLog() {
        return showLog;
    }

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }

    /**
     * 返回请求消息队列管理器的实现类型，目前只有内存实现。
     * @return
     */
    public String getQueueType() {
        return queueType;
    }

    public void setQueueType(String queueType) {
        this.queueType = queueType;
    }

    public String getScanPackagesTcp() {
        return scanPackagesTcp;
    }

    public void setScanPackagesTcp(String scanPackagesTcp) {
        this.scanPackagesTcp = scanPackagesTcp;
    }

    public String getScanPackagesWs() {
        return scanPackagesWs;
    }

    public void setScanPackagesWs(String scanPackagesWs) {
        this.scanPackagesWs = scanPackagesWs;
    }

    public int getPortTcp() {
        return portTcp;
    }

    public void setPortTcp(int portTcp) {
        this.portTcp = portTcp;
    }

    public String getWebsocketUri() {
        return websocketUri;
    }

    public void setWebsocketUri(String websocketUri) {
        this.websocketUri = websocketUri;
    }

    public int getBossThreadNum() {
        return bossThreadNum;
    }

    public void setBossThreadNum(int bossThreadNum) {
        this.bossThreadNum = bossThreadNum;
    }

    public int getWorkerThreadNum() {
        return workerThreadNum;
    }

    public void setWorkerThreadNum(int workerThreadNum) {
        this.workerThreadNum = workerThreadNum;
    }

    public int getPortWs() {
        return portWs;
    }

    public void setPortWs(int portWs) {
        this.portWs = portWs;
    }

    public boolean isOpenHeartBeat() {
        return openHeartBeat;
    }

    public void setOpenHeartBeat(boolean openHeartBeat) {
        this.openHeartBeat = openHeartBeat;
    }

    /**
     * 是否开启自定义：长连接管理器，如果开启则需要业务（创建）配置该对象。
     * @return
     * @date 2023-07-19
     */
    public boolean isCustomConnectionManager() {
        return customConnectionManager;
    }

    public void setCustomConnectionManager(boolean customConnectionManager) {
        this.customConnectionManager = customConnectionManager;
    }

    /**
     * 返回心跳设置的时间，默认：60秒
     * @return
     * @date 2023-08-28
     */
    public long getHeartBeatSeconds() {
        return heartBeatSeconds;
    }

    public void setHeartBeatSeconds(long heartBeatSeconds) {
        this.heartBeatSeconds = heartBeatSeconds;
    }

    /**
     * 是否支持集群模式，true表示支持，会使用负载连接管理器，并启用MQ消息队列。
     * @return
     * @date 2023-09-26
     */
    public boolean isLoadBalanceEnabled() {
        return loadBalanceEnabled;
    }

    public void setLoadBalanceEnabled(boolean loadBalanceEnabled) {
        this.loadBalanceEnabled = loadBalanceEnabled;
    }

    public String getConnectionHost() {
        return connectionHost;
    }

    public void setConnectionHost(String connectionHost) {
        this.connectionHost = connectionHost;
    }

    private String connectionHost;
    private boolean loadBalanceEnabled = false;
    private long heartBeatSeconds = 60;
    private boolean customConnectionManager = false;
    private boolean openHeartBeat = false;
    private int portWs = 60000;
    private boolean enabled = false;
    private boolean showLog = true;
    private String queueType = Constants.QUEUE_TYPE_MEMORY;
    private String scanPackagesTcp;
    private String scanPackagesWs;
    private int portTcp = 7878;
    private String websocketUri = "ws://localhost:60000/websocket";
    private int bossThreadNum = 2;
    private int workerThreadNum = 4;
}
