package com.iplatform.base.di;

import com.walker.di.DataImportException;
import com.walker.di.TemplateException;
import com.walker.di.TemplateGenerator;
import com.walker.infrastructure.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataImportEngine<T> implements DataImportEngine<T>{

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    private TemplateGenerator<T> templateGenerator;

    private String saveFileRootInfo = null;

    @Override
    public void setTemplateGenerator(TemplateGenerator<T> templateGenerator) {
        if(templateGenerator == null){
            throw new IllegalArgumentException("templateGenerator 不能为空!");
        }
        this.templateGenerator = templateGenerator;
    }

    @Override
    public T generateTemplate(TemplateInfo templateInfo) {
        try {
            return this.templateGenerator.generate(templateInfo);
        } catch (TemplateException e) {
            logger.error("生成导入模板错误:" + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String executeImport(JdbcExcelDataImportor dataImportor, String loginId) throws DataImportException {
        // 保存导入历史记录（到数据库）供用户后台查询导入错误结果。
        if(dataImportor == null){
            throw new DataImportException("未传入导入器对象: JdbcExcelDataImportor", null);
        }
        String id = dataImportor.getId();
        if(StringUtils.isNotEmpty(id)){
            logger.debug("保存或者更新导入历史记录,id=" + id);
            try {
                this.saveImportHistory(id, loginId);
            } catch (Exception ex){
                throw new DataImportException("保存导入历史错误:" + ex.getMessage() + ", id=" + id, ex);
            }
        } else {
            logger.info("当前导入未设置id，不记录导入历史, loginId = " + loginId);
        }

        // 这里后续需要考虑ftp集中管理文件的情况。
        dataImportor.setSaveFileFolder(this.saveFileRootInfo);

        dataImportor.load();
        logger.info("导入成功写入{}条记录", dataImportor.getSuccessSize());
        return dataImportor.getErrorFile();
    }

    @Override
    public void setSaveFileRoot(String saveFileRootInfo){
        this.saveFileRootInfo = saveFileRootInfo;
    }

    /**
     * 保存导入历史记录，
     * @param id
     * @param userName
     */
    protected abstract void saveImportHistory(String id, String userName);
}
