package com.iplatform.base.di;

import com.walker.di.DataImportException;
import com.walker.di.TemplateGenerator;

/**
 * 数据导入引擎实现，负责对用户上传的Excel或者其他格式数据能方便导入系统中。
 * <pre>
 *     1)不限于Excel，这只是其中一种
 *     2)输出也不限于数据库，目前仅只有数据库实现。
 * </pre>
 * @author 时克英
 * @date 2023-02-07
 */
public interface DataImportEngine<T> {

    void setTemplateGenerator(TemplateGenerator<T> templateGenerator);

    /**
     * 生成导入模板，该模板由当前处理节点(主机)执行，不需要考虑集群环境。
     * @param templateInfo
     * @return
     */
    T generateTemplate(TemplateInfo templateInfo);

    /**
     * 执行导入动作，返回错误结果文件路径地址。
     * @param dataImportor
     * @param loginId
     * @return
     * @throws DataImportException
     */
    String executeImport(JdbcExcelDataImportor dataImportor, String loginId) throws DataImportException;

    /**
     * 设置引擎存储文件的根路径信息。
     * <pre>
     *     1)有可能是本地文件夹路径，如: d:/demo/file/
     *     2)也可能是FTP的地址，如: ftp://localhost/file/
     * </pre>
     * @param saveFileRootInfo
     */
    void setSaveFileRoot(String saveFileRootInfo);
}
