package com.iplatform.base.di;

import com.iplatform.base.LocalDatabaseMetaEngine;
import com.walker.dbmeta.FieldInfo;
import com.walker.di.excel.ExcelTemplateGenerator;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 平台支持的Excel导入模板生成器实现。<p></p>
 * 通过自动读取元数据，找出表中字段信息，并写入模板头中，目前模板头包括2行:<br>
 * 1)中文说明，2)字段ID
 * @date 2023-02-07
 */
public class PlatformExcelTemplateGenerator extends ExcelTemplateGenerator {

    @Override
    protected String acquireWriteFilePath(Object option) {
        return ((TemplateInfo)option).getTemplatePath();
    }

    @Override
    protected List<Map<String, String>> acquireWriteContent(Object option) {
        String tableName = ((TemplateInfo)option).getTableName();
        if(StringUtils.isEmpty(tableName)){
            throw new RuntimeException("表名不存在，无法创建导入模板", null);
        }

        if(this.localDatabaseMetaEngine == null){
            throw new RuntimeException("localDatabaseMetaEngine 未配置!");
        }

        List<FieldInfo> fieldList = this.localDatabaseMetaEngine.getFieldsObject(tableName);
        if(StringUtils.isEmptyList(fieldList)){
            throw new RuntimeException("该表中未查到任何字段信息");
        }

        List<Map<String, String>> resultList = new ArrayList<>();
        Map<String, String> map = null;
        String comment = null;
        for(FieldInfo fieldInfo : fieldList){
            comment = fieldInfo.getComments();
            if(comment == null){
                comment = StringUtils.EMPTY_STRING;
            }
            map = new HashMap<>();
            map.put(fieldInfo.getFieldName(), comment);
            resultList.add(map);
        }
        logger.debug(resultList.toString());
        return resultList;
    }

    @Override
    protected boolean checkOption(Object option){
        if(!(option instanceof TemplateInfo)){
            return false;
        }
        return true;
    }

    public void setLocalDatabaseMetaEngine(LocalDatabaseMetaEngine localDatabaseMetaEngine) {
        this.localDatabaseMetaEngine = localDatabaseMetaEngine;
    }

    private LocalDatabaseMetaEngine localDatabaseMetaEngine = null;
}
