package com.iplatform.base.exception;

import com.walker.infrastructure.ApplicationException;

/**
 * 登录异常提示定义。
 * <p>目前移动端需要使用，PC端也可重用该对象。</p>
 * @author 时克英
 * @date 2023-06-28
 */
public class LoginException extends ApplicationException {

    /**
     * 用户手机号未找到。
     * @return
     */
    public boolean isUserPhoneNotExist() {
        return userPhoneNotExist;
    }

    private boolean userPhoneNotExist = false;

    public LoginException(String msg){
        super(msg);
    }

    public LoginException(String msg, Throwable caution){
        super(msg, caution);
    }

    public LoginException(String msg, Throwable caution, boolean userPhoneNotExist){
        super(msg, caution);
        if(userPhoneNotExist){
            this.userPhoneNotExist = true;
        }
    }
}
