package com.iplatform.base.pojo;

import com.walker.web.param.ParamRequest;

/**
 * 验证码请求条件。
 * @author 时克英
 * @date 2023-06-27
 */
public class CaptchaParam extends ParamRequest {

    public String getCaptchaType() {
        return captchaType;
    }

    public void setCaptchaType(String captchaType) {
        this.captchaType = captchaType;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getClientUid() {
        return clientUid;
    }

    public void setClientUid(String clientUid) {
        this.clientUid = clientUid;
    }

    public Long getTs() {
        return ts;
    }

    public void setTs(Long ts) {
        this.ts = ts;
    }

    /**
     * 返回拼图滑块的x位置。
     * @return
     * @date 2023-06-27
     */
    public String getX() {
        return x;
    }

    public void setX(String x) {
        this.x = x;
    }

    private String x;

    /**
     * 验证码类型:(clickWord,blockPuzzle)
     */
    private String captchaType;

    /**
     * UUID(每次请求的验证码唯一标识)
     */
    private String token;

    /***
     * 客户端UI组件id,组件初始化时设置一次，UUID
     */
    private String clientUid;
    /***
     * 客户端的请求时间，预留字段
     */
    private Long ts;

    @Override
    public String toString() {
        return "CaptchaParam{" +
                "x='" + x + '\'' +
                ", captchaType='" + captchaType + '\'' +
                ", token='" + token + '\'' +
                ", clientUid='" + clientUid + '\'' +
                ", ts=" + ts +
                '}';
    }
}
