package com.iplatform.base.pojo;

import com.walker.web.ClientType;
import com.walker.web.LoginType;

import java.io.Serializable;

public class RequestLogin implements Serializable {

    /**
     * 用户名
     */
    private String username;

    /**
     * 用户密码
     */
    private String password;

    /**
     * 验证码
     */
    private String code;

    /**
     * 唯一标识（服务端token缓存的标识）
     */
    private String uuid;

    private String loginType = LoginType.INDEX_USER_PASSWORD;

    private String clientType = ClientType.INDEX_PC;

    /**
     * 验证码方式（类型）：code/sms/slide/jigsaw/none
     */
    private String verifyType;

    /**
     * 终端登录，设备唯一编号，如：app设备imei等。
     * @date 2023-03-20
     */
    private String clientId;

    /**
     * 终端登录附带的其他信息，如：操作系统等
     * @date 2023-03-20
     */
    private String clientInfo;

    public String getClientInfo() {
        return clientInfo;
    }

    public void setClientInfo(String clientInfo) {
        this.clientInfo = clientInfo;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    /**
     * 返回验证码类型，值参考：{@linkplain com.walker.web.CaptchaType} 枚举。
     * @return
     */
    public String getVerifyType() {
        return verifyType;
    }

    public void setVerifyType(String verifyType) {
        this.verifyType = verifyType;
    }

    /**
     * 返回终端类型，如:pc/tv/mobile/other
     * @return
     * @date 2023-01-27
     */
    public String getClientType() {
        return clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }


    /**
     * 登录类型，参考: {@linkplain LoginType#INDEX_USER_PASSWORD} | {@linkplain LoginType#INDEX_SMS_CODE} 等。
     * @return
     * @date 2023-01-26 添加属性，支持移动端APP登录
     */
    public String getLoginType() {
        return loginType;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public String getUsername()
    {
        return username;
    }

    public void setUsername(String username)
    {
        this.username = username;
    }

    public String getPassword()
    {
        return password;
    }

    public void setPassword(String password)
    {
        this.password = password;
    }

    public String getCode()
    {
        return code;
    }

    public void setCode(String code)
    {
        this.code = code;
    }

    public String getUuid()
    {
        return uuid;
    }

    public void setUuid(String uuid)
    {
        this.uuid = uuid;
    }

    @Override
    public String toString(){
        return new StringBuilder("[username=").append(this.username)
                .append(", password=").append(this.password)
                .append(", code=").append(this.code)
                .append(", uuid=").append(this.uuid)
                .append(", verifyType=").append(this.verifyType)
                .append(", loginType=").append(this.getLoginType())
                .append(", clientId=").append(this.clientId)
                .append(", clientInfo=").append(this.clientInfo)
                .append("]").toString();
    }
}
