package com.iplatform.base.pojo.form;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;

import java.io.Serializable;

/**
 * 组合中的一条明细记录，该对象在系统中是动态处理的。
 * <pre>
 *     1) group_data表中：value字段是一个模板数据，包含了一个数据集合；
 *     2) 每个数据项包含下面三个字段，这样实现了动态维护分组信息；
 * </pre>
 * @author 时克英
 * @date 2023-05-20
 */
public class FormDataItem implements Serializable {

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public FormDataItem(){}

    //    @ApiModelProperty(value = "字段名称", required = true)
//    @NotBlank(message = "请设置 SystemFormItemCheckRequest 对象的 name 属性")
    private String name;

//    @ApiModelProperty(value = "字段值", required = true)
    /**
     * 配置自定义字符串，反序列实现，否则报错。
     * @date 2023-05-21
     */
//    @JsonDeserialize(using = StringDeserializer.class)
    private String value;

//    @ApiModelProperty(value = "字段显示文字", required = true)
    private String title;
}
