package com.iplatform.base.push;

import com.iplatform.base.UserCacheProvider;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.alidy.DySmsPush;

/**
 * 默认的阿里大鱼短信推送实现。
 * @author 时克英
 * @date 2023-04-24
 */
public class DefaultDySmsPush extends DySmsPush {

    @Override
    protected String getUserMobile(String userId) {
        String mobile = this.userCacheProvider.getUser(Long.parseLong(userId)).getPhonenumber();
        if(StringUtils.isEmpty(mobile)){
            logger.warn("用户手机号不存在，无法推送短信，user={}", userId);
        }
        return mobile;
    }

    public void setUserCacheProvider(UserCacheProvider userCacheProvider) {
        this.userCacheProvider = userCacheProvider;
    }

    private UserCacheProvider userCacheProvider;
}
