package com.iplatform.base.push;

import com.iplatform.base.UserCacheProvider;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.mail.MailPush;

/**
 * 默认实现的邮件推送者。
 * @author 时克英
 * @date 2023-04-24
 */
public class DefaultMailPush extends MailPush {

    @Override
    protected String getUserMail(String userId) {
        String mail = this.userCacheProvider.getUser(Long.parseLong(userId)).getEmail();
        if(StringUtils.isEmpty(mail)){
            logger.warn("用户email不存在，无法推送邮件，user={}", userId);
        }
        return mail;
    }

    public void setUserCacheProvider(UserCacheProvider userCacheProvider) {
        this.userCacheProvider = userCacheProvider;
    }

    private UserCacheProvider userCacheProvider;
}
