package com.iplatform.base.push;

import com.iplatform.base.util.NotificationUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushResult;
import com.walker.push.support.AsyncPushManager;

import java.util.List;

/**
 * 平台默认的推送管理器实现。
 * @author 时克英
 * @date 2023-04-21
 */
public class DefaultPushManager extends AsyncPushManager {

    @Override
    protected void persistent(Notification notification, List<String> successReceiverList, NotificationChannel channel) {
//        if(notification.getPersistent()){
//            logger.info("业务保存'成功通知'：channel = {}, data={}", channel, notification);
//            // 需要考虑多通道情况，对应的是同一个'notificationId'
//            // 如果缓存中已存在，则不再重复保存!
//        }
        // 委托给异步监听器处理，这一代码可复用
        this.getAsyncListener().onSuccess(notification, successReceiverList, channel);
    }

    @Override
    protected void persistentFailed(Notification notification, List<String> failedList, NotificationChannel channel) {
//        if(notification.getPersistent()){
//            logger.info("业务保存'失败通知'：channel = {}, data = {}", channel, notification);
//        }
        this.getAsyncListener().onException(notification, null, channel);
    }

    @Override
    public PushResult pushSms(Notification notification) {
        if(this.smsId == null){
            throw new IllegalStateException("短信推送者ID为空!");
        }
        return this.push(notification, this.smsId);
    }

    /**
     * 发送短信验证码推送。
     * @param code 验证码
     * @param mobile 手机号（或用户ID）都可以
     * @param creator 创建人ID
     * @return
     * @date 2023-04-25
     */
    public PushResult pushSmsValidateCode(String code, String mobile, String creator){
        Notification notification = NotificationUtils.acquireSmsValidateCode(this.smsTemplateCode, code, mobile, creator);
        return this.push(notification, this.smsId);
    }

    /**
     * 设置短信推送者ID，因为可能存在多个
     * @param smsId
     */
    public void setSmsId(String smsId) {
        this.smsId = smsId;
    }

    /**
     * 设置短信验证码模板ID
     * @param smsTemplateCode
     */
    public void setSmsTemplateCode(String smsTemplateCode) {
        this.smsTemplateCode = smsTemplateCode;
    }

    /**
     * 获得邮件发送地址配置信息。临时这样处理。
     * @return
     * @date 2023-04-26
     */
    public String getMailFrom() {
        return mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    private String mailFrom;
    private String smsTemplateCode;
    private String smsId = null;
}
