package com.iplatform.base.push;

import com.iplatform.base.Constants;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.SmsMessage;
import com.walker.push.support.AbstractSmsPush;
import com.walker.push.util.PushUtils;

import java.util.List;

/**
 * 模拟短信发送的推送实现。
 * @author 时克英
 * @date 2023-04-25
 */
public class MockSmsPush extends AbstractSmsPush {

    public MockSmsPush(){
        this.setId(Constants.PUSH_SMS_ID_MOCK);
        this.setName("模拟短信推送");
    }

    @Override
    protected String getUserMobile(String userId) {
        return "13900001111";
    }

    @Override
    protected PushResult doPushContent(Notification notification, List<SmsMessage> data) throws PushException {
        PushResult pushResult = PushUtils.acquireSuccessPushResult();

        // 对于短信来说，通常一个提醒只会通知一人，不会群发同一个信息给多人。
        // 因为一个：SmsMessage 中就能放多个手机号，所以其实只有一个对象。
        SmsMessage smsMessage = data.get(0);

        String phoneNumbers = StringUtils.collectionToDelimitedString(smsMessage.getMobileList(), StringUtils.DEFAULT_SPLIT_SEPARATOR);
        logger.debug("模拟发送短信 --> {}，内容={}", phoneNumbers, notification.getContent());
        return pushResult;
    }

    @Override
    public void startup() {

    }
}
