package com.iplatform.base.push;

import com.iplatform.base.PushData;
import com.walker.push.AbstractPushObject;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.util.PushUtils;

import java.util.List;

/**
 * 平台默认的系统消息推送，默认并不推送，仅仅记录数据，由前端主动拉取消息记录。
 * @author 时克英
 * @date 2023-04-25
 */
public class SystemPush extends AbstractPushObject<PushData> {

    public SystemPush(){
        this.setId(NotificationChannel.System.getIndex());
        this.setName(NotificationChannel.System.getName());
    }

    @Override
    protected PushResult doPushContent(Notification notification, List<PushData> data) throws PushException {
        // 由于不推送，所以直接返回成功，让推送管理器保存数据即可。
        return PushUtils.acquireSuccessPushResult();
    }

    @Override
    public NotificationChannel getNotificationChannel() {
        return NotificationChannel.System;
    }

    @Override
    public List<PushData> translateToTarget(Notification notification) {
        return null;
    }

    @Override
    public void startup() {

    }
}
