package com.iplatform.base.service;

import com.iplatform.model.po.S_config;
import com.iplatform.model.po.S_dict_type;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ConfigArgumentServiceImpl extends BaseServiceImpl {

    private static final String SQL_PAGE_LIST_PREFIX = "select * from s_config where 1=1";
    private static final String SQL_UPDATE_CONFIG = "update s_config set config_value=? where config_key=?";

    /**
     * 从表单分组配置中，更新整个分组配置
     * @param savedConfigList
     * @date 2023-05-31
     */
    public void execUpdateFormConfig(List<Object[]> savedConfigList){
        this.execBatchUpdate(SQL_UPDATE_CONFIG, savedConfigList);
    }

    /**
     * 查询分组下的参数集合。<p></p>
     * 通常该方法调用方是为了初始化加载参数，而不是频繁业务调用。<br>
     * 目前：支付模块初始化引擎使用。
     * @param group 分组名称
     * @return
     * @date 2023-03-01
     */
    @Deprecated
    public List<S_config> queryGroupConfigList(String group){
        return this.select(new S_config(), "where group_id=?", new Object[]{group});
    }

    public S_config queryConfigByKey(String key){
        List<S_config> list = this.select(new S_config(), "where config_key=?", new Object[]{key});
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        return list.get(0);
    }

    public GenericPager<S_config> queryPageConfigList(String configName, String configKey, String configType){
        Map<String, Object> parameters = new HashMap<>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_LIST_PREFIX);
        if(StringUtils.isNotEmpty(configName)){
            sql.append(" and config_name like :configName");
            parameters.put("configName", "%" + configName + "%");
        }
        if(StringUtils.isNotEmpty(configKey)){
            sql.append(" and config_key like :configKey");
            parameters.put("configKey", "%" + configKey + "%");
        }
        if(StringUtils.isNotEmpty(configType)){
            sql.append(" and config_type = :configType");
            parameters.put("configType", configType);
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), new S_config());
    }
}
