package com.iplatform.base.service;

import com.iplatform.model.po.S_config_form;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class ConfigFormServiceImpl extends BaseServiceImpl {

    public int queryNextId(){
        int maxId = this.queryForInt(SQL_MAX_ID, new Object[]{});
        return maxId+1;
    }

    public GenericPager<S_config_form> queryPageFormList(String keywords){
        Map<String, Object> parameters = new HashMap<>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_LIST);

        if(StringUtils.isNotEmpty(keywords)){
            sql.append(" and (name like :name or info like :info)");
            parameters.put("name", "%" + keywords + "%");
            parameters.put("info", "%" + keywords + "%");
        }
        sql.append(" order by id desc");
        return this.selectSplit(sql.toString(), parameters, new S_config_form());
    }

    private static final String SQL_MAX_ID = "select max(id) from s_config_form";
    private static final String SQL_PAGE_LIST = "select * from s_config_form where 1=1";
}
