package com.iplatform.base.service;

import com.iplatform.model.po.S_group;
import com.iplatform.model.po.S_group_data;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class GroupServiceImpl extends BaseServiceImpl {

    /**
     * 根据分组项ID，查询项目记录。
     * @param dataId
     * @return
     * @date 2023-09-11
     */
    public S_group_data queryGroupData(int dataId){
        return this.get(new S_group_data(dataId));
    }

    public List<S_group_data> queryAllGroupDataList(){
        return this.select("select * from s_group_data where status=1 order by gid, sort", new Object[]{}, new S_group_data());
    }

    /**
     * 获得(s_group_data)表下一个可用的最大ID。
     * @return
     * @date 2023-05-20
     */
    public int queryGroupDataNextId(){
        int maxId = this.queryForInt(SQL_MAX_ID_GROUP_DATA, new Object[]{});
        return maxId+1;
    }

    /**
     * 获得(s_group)表下一个可用的最大ID。
     * @return
     * @date 2023-05-20
     */
    public int queryGroupNextId(){
        int maxId = this.queryForInt(SQL_MAX_ID_GROUP, new Object[]{});
        return maxId+1;
    }

    public GenericPager<S_group_data> queryPageGroupDataList(int groupId, Integer status){
        Map<String, Object> params = new HashMap<>(4);
        params.put("gid", groupId);

        StringBuilder sql = new StringBuilder(SQL_PAGE_GROUP_DATA);
        if(status != null){
            sql.append(" and status=:status");
            params.put("status", status.intValue());
        }
        sql.append(" order by sort desc");

        return this.selectSplit(sql.toString(), params, new S_group_data());
    }

    public GenericPager<S_group> queryPageGroupList(String keywords){
        S_group group = new S_group();
        if(StringUtils.isNotEmpty(keywords)){
            String search = StringUtils.CHAR_PERCENT + keywords + StringUtils.CHAR_PERCENT;
            return this.selectSplit("select * from s_group where name like ? or info like ? order by id desc"
                    , new Object[]{search, search}, group);
        }
        return this.selectSplit(group);
    }

    private static final String SQL_MAX_ID_GROUP_DATA = "select max(id) from s_group_data";
    private static final String SQL_MAX_ID_GROUP = "select max(id) from s_group";
    private static final String SQL_PAGE_GROUP_DATA = "select * from s_group_data where gid=:gid";
}
