package com.iplatform.base.service;

import com.iplatform.model.po.S_login_info;
import com.iplatform.model.po.S_oper_log;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class LogServiceImpl extends BaseServiceImpl {

    private static final String SQL_PAGE_LOGIN_LOG = "select * from s_login_info where 1=1";
    private static final String SQL_PAGE_OPERATE_LOG = "select * from s_oper_log where 1=1";

    /**
     * 分页查询操作日志。
     * @param operateName
     * @param businessType
     * @param status
     * @param title
     * @return
     * @date 2023-01-09
     */
    public GenericPager<S_oper_log> queryPageOperateLogList(String operateName
            , Integer businessType, Integer status, String title){
        Map<String, Object> parameters = new HashMap<>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_OPERATE_LOG);
        if(StringUtils.isNotEmpty(operateName)){
            sql.append(" and oper_name = :operateName");
            parameters.put("operateName", operateName);
        }
        if(businessType != null){
            sql.append(" and business_type = :businessType");
            parameters.put("businessType", businessType.intValue());
        }
        if(status != null && (status.intValue() == 1 || status.intValue() == 0)){
            sql.append(" and status = :status");
            parameters.put("status", status.intValue());
        }
        if(StringUtils.isNotEmpty(title)){
            sql.append(" and title = :title");
            parameters.put("title", title);
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), new S_oper_log());
    }

    /**
     * 分页查询登录日志
     * @param ip
     * @param userName
     * @param status
     * @return
     * @date 2023-01-05
     */
    public GenericPager<S_login_info> queryPageLoginLogList(String ip, String userName, String status){
        Map<String, Object> parameters = new HashMap<>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_LOGIN_LOG);

        if(StringUtils.isNotEmpty(ip)){
            sql.append(" and ipaddr = :ipaddr");
            parameters.put("ipaddr", ip);
        }
        if(StringUtils.isNotEmpty(userName)){
            sql.append(" and user_name = :userName");
            parameters.put("userName", userName);
        }
        if(StringUtils.isNotEmpty(status)){
            sql.append(" and status = :status");
            parameters.put("status", status);
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), new S_login_info());
    }

    public void execClearOperateLog(){
        this.execute("truncate table s_oper_log", new Object[]{});
    }

    public void execClearLoginLog(){
        this.execute("truncate table s_login_info", new Object[]{});
    }

    public void execInsertOperateLog(S_oper_log s_oper_log){
        s_oper_log.setOper_time(DateUtils.getDateTimeNumber(System.currentTimeMillis()));
        s_oper_log.setOper_id(NumberGenerator.getLongSequenceNumber());
        this.insert(s_oper_log);
    }

    /**
     * 写入一条登录日志，目前修改为：只有登录失败才会调用该方法。<p></p>
     * 请参考：{@linkplain LoginServiceImpl#execUpdateUserLogin(long, String, String, String, S_login_info)}
     * @param s_login_info
     * @param userId
     * @date 2023-03-23
     */
    public void execInsertLoginLog(S_login_info s_login_info, Long userId){
        if(s_login_info != null){
            this.insert(s_login_info);
        }
    }


}
