package com.iplatform.base.service;

import com.iplatform.model.po.S_login_info;
import com.iplatform.model.po.S_user_login;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl extends BaseServiceImpl {

    /**
     * 根据用户id返回曾经登录过的uuid
     * @param userId
     * @return
     * @date 2023-03-22
     */
    public String queryLoginUUID(long userId){
        S_user_login exist = this.get(new S_user_login(userId));
        if(exist == null){
            return null;
        }
        return exist.getUuid();
    }

    /**
     * 创建用户登录关联（多账户）信息，为后续通过userId查找uuid（缓存key）准备数据。
     * @param userId
     * @param loginId
     * @param uuid 系统缓存登录用户的key
     * @param clientType
     * @date 2023-03-22
     */
    public S_user_login execUpdateUserLogin(long userId
            , String loginId, String uuid, String clientType, S_login_info s_login_info, boolean update){
        S_user_login exist = null;
        if(!update){
            // 不存在，创建记录
            exist = this.get(new S_user_login(userId));
            if(exist == null){
                exist = new S_user_login(userId);
                exist.setUser_name(loginId);
                exist.setCreate_time(DateUtils.getDateTimeNumber());
                exist.setUpdate_time(exist.getCreate_time());
                exist.setUuid(uuid);
                exist.setClient_type(clientType);
                this.insert(exist);
            } else {
                exist.setUpdate_time(DateUtils.getDateTimeNumber());
                exist.setUuid(uuid);
                exist.setClient_type(clientType);
                this.save(exist);
            }

        } else {
            // 已存在，更新uuid
            exist = new S_user_login(userId);
            exist.setUser_name(loginId);
            exist.setUuid(uuid);
            exist.setUpdate_time(DateUtils.getDateTimeNumber());
            exist.setClient_type(clientType);
            this.save(exist);
        }

        // 把登录日志保存放在一起。2023-03-23
        if(s_login_info != null){
            this.insert(s_login_info);
        }
        return exist;
    }

//    public void execUpdateUserLogin(long userId
//            , String loginId, String uuid, String clientType, S_login_info s_login_info){
//        S_user_login exist = this.get(new S_user_login(userId));
//        if(exist == null){
//            // 不存在，创建记录
//            exist = new S_user_login(userId);
//            exist.setUser_name(loginId);
//            exist.setCreate_time(DateUtils.getDateTimeNumber());
//            exist.setUpdate_time(exist.getCreate_time());
//            exist.setUuid(uuid);
//            exist.setClient_type(clientType);
//            this.insert(exist);
//
//        } else {
//            // 已存在，更新uuid
//            exist = new S_user_login(userId);
//            exist.setUuid(uuid);
//            exist.setUpdate_time(DateUtils.getDateTimeNumber());
//            exist.setClient_type(clientType);
//            this.save(exist);
//        }
//
//        // 把登录日志保存放在一起。2023-03-23
//        if(s_login_info != null){
//            this.insert(s_login_info);
//        }
//    }
}
