package com.iplatform.base.service;

import com.iplatform.model.po.SfNotification;
import com.iplatform.model.po.SfTemplateMessage;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 系统通知提醒配置，微信公众号模板配置等公用。
 * @date 2023-08-24
 */
@Service
public class NotificationServiceImpl extends BaseServiceImpl {

    public Map<Long, SfTemplateMessage> queryTemplateIdMap(){
        Map<Long, SfTemplateMessage> map = new HashMap<>(8);
        List<SfTemplateMessage> list = this.select(new SfTemplateMessage());
        if(!StringUtils.isEmptyList(list)){
            for(SfTemplateMessage templateMessage : list){
                if(templateMessage.getStatus().intValue() == 0){
                    continue;
                }
                map.put(templateMessage.getId(), templateMessage);
            }
        }
        return map;
    }

    public List<SfNotification> queryList(Integer sendType){
        SfNotification param = new SfNotification();
        if(sendType != null){
            param.setSendType(sendType);
        }
        return this.select(param);
    }
}
