package com.iplatform.base.service;

import com.iplatform.base.Constants;
import com.iplatform.base.DeptCacheProvider;
import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.service_api.UserAndDeptServiceApi;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_dept;
import com.iplatform.model.po.S_user_core;
import com.iplatform.model.to.UserAndDeptTo;
import com.iplatform.model.to.UserAndDeptToResult;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import com.walker.web.OrgType;
import com.walker.web.ResponseValue;
import com.walker.web.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserDeptApiServiceImpl extends BaseServiceImpl implements UserAndDeptServiceApi {

    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object execInsertMobileUserRegister(String phone){

        return null;
    }

    @Override
    public ResponseValue execInsertTopOrgAndAdmin(UserAndDeptTo userAndDeptTo){
        if(userAndDeptTo == null
                || StringUtils.isEmpty(userAndDeptTo.getDeptName())
                || StringUtils.isEmpty(userAndDeptTo.getUserName())){
            throw new IllegalArgumentException(Constants.ERROR_ARGUMENT);
        }

        UserAndDeptToResult result = new UserAndDeptToResult();

        S_dept existDept = this.existSameNameOrg(userAndDeptTo.getDeptName());
        if(existDept != null){
//            result.setMessage("顶级机构名称已经存在，无法重复添加");
            // 如果之前已经调用过写入数据，这里会直接返回，因为可能存在网络调用后第三方系统调用业务失败情况！
            S_user_core existUser = this.existSameNameUser(userAndDeptTo.getUserName());
            if(existUser != null){
                logger.warn("已经存在用户和机构，直接返回：deptId={}, userId={}", existDept.getId(), existUser.getId());
                result.setDeptId(existDept.getId());
                result.setUserId(existUser.getId());
                return ResponseValue.success(result);
            }
            return ResponseValue.error("顶级机构名称已经存在，无法重复添加");
        }

        long nextOrgId = this.queryNextDeptId();

        S_dept dept = new S_dept();
        dept.setId(nextOrgId);
        dept.setOrg_id(nextOrgId);
        dept.setOrg_type(OrgType.TYPE_ORG);
        dept.setParent_id(0L);
        dept.setAncestors("0");
        dept.setDept_name(userAndDeptTo.getDeptName());
        dept.setCreate_by(userAndDeptTo.getCreateId());
        dept.setOrder_num((int)nextOrgId);
        dept.setCreate_time(DateUtils.getDateTimeNumber());
        dept.setMenu_type(userAndDeptTo.getMenuType());
        dept.setPhone(userAndDeptTo.getPhone());
        dept.setEmail(userAndDeptTo.getMail());
        this.insert(dept);

        S_user_core user = new S_user_core();
        user.setId(NumberGenerator.getLongSequenceNumber());
        user.setCreate_time(dept.getCreate_time());
        user.setCreate_by(userAndDeptTo.getCreateId());
        user.setUpdate_time(dept.getCreate_time());
        user.setDept_id(nextOrgId);
        user.setOrg_id(nextOrgId);
        user.setUser_name(userAndDeptTo.getUserName());
        user.setNick_name(userAndDeptTo.getNickName());
        user.setUser_type(UserType.TYPE_MERCHANT_ADMIN);
        user.setPassword(userAndDeptTo.getPassword());  // 加密过的密码
        if(StringUtils.isNotEmpty(userAndDeptTo.getPhone())){
            user.setPhonenumber(userAndDeptTo.getPhone());
        }
        if(StringUtils.isNotEmpty(userAndDeptTo.getMail())){
            user.setEmail(userAndDeptTo.getMail());
        }
        user.setType(UserType.TYPE_MERCHANT_ADMIN);
        user.setMer_id(nextOrgId);
        this.insert(user);

        // 添加系统缓存
        BeanContextAware.getBeanByType(DeptCacheProvider.class).putDept(dept);
        BeanContextAware.getBeanByType(UserCacheProvider.class).putUser(user);

        result.setDeptId(nextOrgId);
        result.setUserId(user.getId());
        return ResponseValue.success(result);
    }

    @Override
    public ResponseValue execUpdateTopOrgAndAdmin(UserAndDeptTo userAndDeptTo) {
        // 机构只能修改这些不重要属性，用户不修改。
        S_dept dept = new S_dept(userAndDeptTo.getOrgId());
        dept.setDept_name(userAndDeptTo.getDeptName());
        dept.setEmail(userAndDeptTo.getMail());
        dept.setPhone(userAndDeptTo.getPhone());
        this.save(dept);
        dept = this.get(new S_dept(userAndDeptTo.getOrgId()));
        // 添加系统缓存
        BeanContextAware.getBeanByType(DeptCacheProvider.class).updateDept(dept);
        return ResponseValue.success();
    }

    private S_user_core existSameNameUser(String loginId){
        S_user_core user = new S_user_core();
        user.setUser_name(loginId);
        List<S_user_core> list = this.select(user);
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        return list.get(0);
    }

    private S_dept existSameNameOrg(String name){
        S_dept dept = new S_dept();
        dept.setDept_name(name);
        dept.setOrg_type(OrgType.TYPE_ORG);
        List<S_dept> list = this.select(dept);
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        return list.get(0);
    }

    /**
     * 获得下一个可用的最大ID。
     * @return
     * @date 2023-05-17
     */
    public int queryNextDeptId(){
        int maxId = this.queryForInt(SQL_MAX_DEPT_ID, new Object[]{});
        return maxId+1;
    }

    private static final String SQL_MAX_DEPT_ID = "select count(id) from s_dept";
}
