package com.iplatform.base.support;

import com.iplatform.base.Constants;
import com.iplatform.base.service.ConfigArgumentServiceImpl;
import com.iplatform.base.util.ArgumentsManagerUtils;
import com.iplatform.core.SimpleVariable;
import com.iplatform.model.po.S_config;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.Group;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.arguments.VariableType;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.security.SystemLogMan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 基于内存实现的可变参数管理器实现。
 * @author 时克英
 * @date 2022-11-29
 */
public class DatabaseArgumentsManager extends AbstractCacheProvider<Variable> implements ArgumentsManager {

    private ConfigArgumentServiceImpl configArgumentService = null;

    // 2023-05-16，按照formId分组配置集合
    private Map<String, List<Variable>> formGroupReference = new HashMap<>();

    public void setConfigArgumentService(ConfigArgumentServiceImpl configArgumentService) {
        this.configArgumentService = configArgumentService;
        SystemLogMan.getInstance().checkMan();
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<S_config> hosts = this.configArgumentService.selectAll(new S_config());
        if(!StringUtils.isEmptyList(hosts)){
            Variable variable = null;
            List<Variable> groupList = null;
            for(S_config h : hosts){
//                cache.put(String.valueOf(h.getId()), h);
                variable = ArgumentsManagerUtils.toVariable(h.getConfig_key(), h.getConfig_value(), h.getData_type());
                cache.put(String.valueOf(h.getConfig_key()), variable);

                // 2023-05-16
                groupList = this.formGroupReference.get(String.valueOf(h.getForm_id()));
                if(groupList == null){
                    groupList = new ArrayList<>(8);
                    this.formGroupReference.put(String.valueOf(h.getForm_id()), groupList);
                }
                groupList.add(variable);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_ARGUMENTS;
    }

    @Override
    public Class<?> getProviderType() {
        return Variable.class;
    }

    @Override
    public Variable getVariable(String id) {
        return this.getCacheData(id);
    }

    @Override
    public void persist(String variableId, Object value) {
        SimpleVariable variable = ArgumentsManagerUtils.toVariable(variableId, value.toString(), VariableType.DEF_STRING);
        this.updateCacheData(variableId, variable);
    }

    @Override
    public void persist(String groupId, String variableId, Object value) {
        this.persist(variableId, value);
    }

    @Override
    public void persist(List<Object[]> changedList) {
        throw new UnsupportedOperationException("未实现代码");
    }

    @Override
    public void insert(List<Object[]> insertList) {
        throw new UnsupportedOperationException("未实现代码");
    }

    @Override
    public List<Group> getGroupList() {
        throw new UnsupportedOperationException("未实现代码");
    }

    @Override
    public List<Variable> getVariableList(String groupId) {
//        List<S_config> configList = this.configArgumentService.queryGroupConfigList(groupId);
//        return ArgumentsManagerUtils.acquireGroupVariableList(configList);
        // 使用新机制，根据formId返回分组参数集合。
        return this.formGroupReference.get(groupId);
    }

    @Override
    public void setSource(Object source) {

    }
}
