package com.iplatform.base.support;

import com.iplatform.model.po.S_dept;
import com.walker.infrastructure.tree.AbstractTreeGenerator;
import com.walker.infrastructure.tree.TreeNode;

/**
 * 组织机构树生成器实现。<p></p>
 * 前端VUE组件需要树机构对象。
 * @date 2022-12-08
 */
public class DeptTreeGenerator extends AbstractTreeGenerator<S_dept> {

    public DeptTreeGenerator(String dummyRootName){
        super(dummyRootName);
        this.setMultiRoot(true);
    }

    @Override
    protected TreeNode toTreeNode(S_dept entity) {
        TreeNode treeNode = new TreeNode(entity.getId(), entity.getDept_name(), null, entity.getParent_id());
        return treeNode;
    }
}
