package com.iplatform.base.support;

import com.iplatform.model.po.S_dict_data;
import com.walker.infrastructure.tree.AbstractTreeGenerator;
import com.walker.infrastructure.tree.TreeNode;

/**
 * 基于'数据字典'树结构生成器对象，前端VUE组件需要树对象。
 * @author 时克英
 * @date 2023-03-13
 */
public class DictTreeGenerator extends AbstractTreeGenerator<S_dict_data> {

    public DictTreeGenerator(String dummyRootName) {
        super(dummyRootName);
        this.setMultiRoot(true);    // 支持多个根节点
    }

    @Override
    protected TreeNode toTreeNode(S_dict_data entity) {
        TreeNode treeNode = new TreeNode(entity.getDict_code(), entity.getDict_label(), null, entity.getParent_id());
        return treeNode;
    }
}
