package com.iplatform.base.support;

import com.iplatform.base.SecuritySpi;
import com.iplatform.base.exception.LoginException;
import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.model.po.S_user_core;
import com.walker.web.UserPrincipal;

import java.util.List;
import java.util.Map;

/**
 * 安全控制SPI的默认实现，没有任何操作，主要是为了让没有 iplatform-base-security 的模块不报错。
 * @author 时克英
 * @date 2022-11-28
 */
public class NothingSecuritySpi implements SecuritySpi {

    public NothingSecuritySpi(){}

    @Override
    public List<String> getCurrentUserRoleIdList() {
        return null;
    }

    @Override
    public UserPrincipal<S_user_core> getCurrentUserPrincipal() {
        return null;
    }

    @Override
    public S_user_core getCurrentUser() {
        return null;
    }

    @Override
    public long getCurrentUserId() {
        return 0;
    }

    @Override
    public String encryptPassword(String password) {
        return null;
    }

    @Override
    public boolean matchesPassword(String rawPassword, String encodedPassword) {
        return false;
    }

    @Override
    public boolean isAllowMobileLoginRegister() {
        return false;
    }

    @Override
    public Map<String, Object> login(RequestLogin requestLogin) throws LoginException {
        return null;
    }

    @Override
    public void loginAsWorkflowRole() {

    }
}
