package com.iplatform.base.support;

import com.iplatform.base.VariableConstants;
import com.iplatform.base.util.TokenUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.TokenException;
import com.walker.web.TokenGenerator;
import com.walker.web.interceptor.WebOperationInterceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

/**
 * 平台基本操作拦截器，主要针对界面操作。
 * @author 时克英
 * @date 2023-03-09
 */
public class PlatformOperationInterceptor extends WebOperationInterceptor {

    @Override
    protected boolean doPreHandleOther(String servletPath, HttpServletRequest request, HttpServletResponse response){
        return this.checkReportView4Jim(servletPath, request);
    }

    private boolean checkReportView4Jim(String servletPath, HttpServletRequest request){
        if(servletPath.indexOf(REPORT_VIEW_JIM) >= 0){
            // 获取token验证
            String token = TokenUtils.getAuthorizationToken(request, REPORT_TOKEN_NAME);
            if(StringUtils.isEmpty(token)){
                logger.debug("-----> token 为空");
                return false;
            }
            String data = null;
            try {
                data = tokenGenerator.validateToken(token, VariableConstants.TOKEN_SECRET);
                String[] userIdAndKey = TokenUtils.getUserIdAndKey(data);
                String loginId = userIdAndKey[1];
                return true;

            } catch (TokenException e) {
                logger.error("查看报表token验证错误:" + e.getMessage(), e);
                return false;
            }
        }
        return true;
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    private TokenGenerator tokenGenerator;
    private static final String REPORT_VIEW_JIM = "/jmreport/view/";
    private static final String REPORT_TOKEN_NAME = "token";
}
