package com.iplatform.base.support.strategy;

import com.iplatform.base.UserLoginCache;
import com.iplatform.core.LoginStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginStrategy implements LoginStrategy {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public UserLoginCache getUserLoginCache() {
        return userLoginCache;
    }

    public void setUserLoginCache(UserLoginCache userLoginCache) {
        this.userLoginCache = userLoginCache;
    }

    private UserLoginCache userLoginCache;
    private boolean enabled = false;
    private String name;
}
