package com.iplatform.base.support.strategy;

import com.iplatform.base.UserLoginCache;
import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.core.LoginStrategy;
import com.iplatform.model.po.S_user_login;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * 登录策略管理器。
 * @author 时克英
 * @date 2023-07-11
 */
public class LoginStrategyManager {

    protected final transient Logger logger =  LoggerFactory.getLogger(getClass());

    private final Map<String, LoginStrategy> loginStrategyMap = new HashMap<>(4);
    private int count = 0;

    public void register(String key, LoginStrategy loginStrategy){
        if(loginStrategy == null){
            throw new IllegalArgumentException("loginStrategy不能为空");
        }
//        String key = loginStrategy.getClass().getName();
        if(this.loginStrategyMap.containsKey(key)){
            throw new IllegalArgumentException("loginStrategy注册重复：" + loginStrategy.getName());
        }
        this.loginStrategyMap.put(key, loginStrategy);
        logger.info("注册【登录策略】对象:{}", key);
        count ++;
    }

    /**
     * 执行策略
     * @param requestLogin 登录信息
     * @return
     */
    public String execute(RequestLogin requestLogin){
        if(this.count == 0){
            return null;
        }
        for(LoginStrategy loginStrategy : this.loginStrategyMap.values()){
            if(loginStrategy.isEnabled() && !loginStrategy.allowLogin(requestLogin.getUsername(), requestLogin.getClientType())){
                return loginStrategy.acquireError();
            }
        }
        return null;
    }

    public boolean hasUserLogin(String loginId){
        return this.userLoginCache.getUserLogin(loginId) != null;
    }

    public void putUserLoginCache(S_user_login user_login){
        this.userLoginCache.putUserLogin(user_login);
    }
    public void updateUserLoginCache(S_user_login user_login){
        this.userLoginCache.updateUserLogin(user_login);
    }

    /**
     * 根据登录ID，返回登录信息。
     * @param loginId
     * @return
     * @date 2023-08-05
     */
    public S_user_login getUserLogin(String loginId){
        return this.userLoginCache.getUserLogin(loginId);
    }

    public void setUserLoginCache(UserLoginCache userLoginCache) {
        this.userLoginCache = userLoginCache;
    }

    private UserLoginCache userLoginCache;
}
