package com.iplatform.base.support.strategy;

import com.iplatform.model.po.S_user_login;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.web.ClientType;

/**
 * 移动端无论多少终端，只能登录一个，拒绝重复登录。
 * <p>如果要想重新登录，必须先登出。或者等待token超时。</p>
 * @author 时克英
 * @date 2023-07-11
 */
public class MobileOnceLoginStrategy extends AbstractLoginStrategy{

    @Override
    public boolean allowLogin(String loginId, String clientType) {
        if(this.tokenExpireMobile == 0){
            throw new IllegalArgumentException("请先配置bean属性：tokenExpireMobile");
        }
        if(!clientType.equals(ClientType.INDEX_MOBILE)){
            // 非移动端，不检测
            return true;
        }
        S_user_login login = this.getUserLoginCache().getUserLogin(loginId);
        if(login == null){
            logger.debug("缓存中没有登录记录，允许登录，loginId={}", loginId);
            return true;
        }

        // 检查是否登录超时，根据记录中更新时间，对比移动端token是否失效。
        // 毫秒转换成分钟
        long spanTime = (System.currentTimeMillis() - DateUtils.toMillSeconds(login.getUpdate_time())) / 60000;
        if(spanTime <= this.tokenExpireMobile){
            logger.debug("登录在token范围内，不允许登录，loginId={}", login);
            return false;
        }
        return true;
    }

    @Override
    public String acquireError() {
        return ERROR;
    }

    public void setTokenExpireMobile(long tokenExpireMobile) {
        this.tokenExpireMobile = tokenExpireMobile;
    }

    private long tokenExpireMobile = 0;
    private static final String ERROR = "同一账号无法重复登录";
}
