package com.iplatform.base.support.strategy;

import com.iplatform.model.po.S_user_login;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.web.ClientType;

/**
 * Web（PC）端，登录策略：只能登录一次实现
 * @author 时克英
 * @date 2023-09-08
 */
public class WebOnceLoginStrategy extends MobileOnceLoginStrategy{

    @Override
    public boolean allowLogin(String loginId, String clientType) {
        if(this.tokenExpireWeb == 0){
            throw new IllegalArgumentException("请先配置bean属性：tokenExpireMobile");
        }
        if(!clientType.equals(ClientType.INDEX_PC)){
            // 非PC端，不检测
            return true;
        }
        S_user_login login = this.getUserLoginCache().getUserLogin(loginId);
        if(login == null){
            logger.debug("缓存中没有登录记录，允许登录，loginId={}", loginId);
            return true;
        }

        // 检查是否登录超时，根据记录中更新时间，对比移动端token是否失效。
        // 毫秒转换成分钟
        long spanTime = (System.currentTimeMillis() - DateUtils.toMillSeconds(login.getUpdate_time())) / 60000;
        if(spanTime <= this.tokenExpireWeb){
            logger.debug("登录在token范围内，不允许登录，loginId={}", login);
            return false;
        }
        return true;
    }

    public long getTokenExpireWeb() {
        return tokenExpireWeb;
    }

    public void setTokenExpireWeb(long tokenExpireWeb) {
        this.tokenExpireWeb = tokenExpireWeb;
    }

    private long tokenExpireWeb = 600;              // PC端默认2小时
}
