package com.iplatform.base.util;

import com.iplatform.core.SimpleVariable;
import com.iplatform.model.po.S_config;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.arguments.VariableType;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class ArgumentsManagerUtils {

    /**
     * 把数据库中给定的分组参数，组装成公共参数对象集合返回业务。
     * @param configList 数据库加载的集合
     * @return
     * @date 2023-03-01
     */
    public static final List<Variable> acquireGroupVariableList(List<S_config> configList){
        if(StringUtils.isEmptyList(configList)){
            return null;
        }
        List<Variable> groupVariableList = new ArrayList<>();
        for(S_config s_config : configList){
            groupVariableList.add(ArgumentsManagerUtils
                    .toVariable(s_config.getConfig_key(), s_config.getConfig_value(), VariableType.DEF_STRING));
        }
        return groupVariableList;
    }

    public static final SimpleVariable toVariable(String key , String value, String dataType){
        SimpleVariable variable = new SimpleVariable();
        variable.setId(key);
        variable.setStringValue(value);
        variable.setDataType(dataType);
        return variable;
    }

}
