package com.iplatform.base.util;

import com.iplatform.base.Constants;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.CaptchaResult;

public class CaptchaUtils {

    /**
     * 返回验证码缓存标识，即：存储在redis（或内存）中的唯一标识。<p></p>
     * 目前使用表示规则 = captcha_codes:uuid
     * @param data
     * @return
     * @date 2023-04-07
     */
    public static final String getVerifyKey(CaptchaResult data){
        if(data == null || StringUtils.isEmpty(data.getUuid())){
            throw new IllegalArgumentException("待验证信息未空，或者uuid不存在!");
        }
        return Constants.CAPTCHA_CODE_PREFIX + data.getUuid();
    }
}
