package com.iplatform.base.util;

import com.iplatform.base.util.cache.CategorySortComparator;
import com.iplatform.model.po.S_category;
import com.iplatform.model.vo.CategoryTreeVo;
import com.walker.infrastructure.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategoryUtils {

    protected static Logger logger = LoggerFactory.getLogger(CategoryUtils.class);

    public static final List<CategoryTreeVo> acquireListTree(List<S_category> allTree, CategorySortComparator sortComparator){
        // 重新排序
        Collections.sort(allTree, sortComparator);
        //
        List<CategoryTreeVo> treeList = new ArrayList<>();
        if(allTree.size() == 0){
            return treeList;
        }

        //
        for (S_category category : allTree) {
            treeList.add(CategoryUtils.toCategoryTreeVo(category));
        }

        Map<Integer, CategoryTreeVo> map = new HashMap<>(treeList.size());
        //ID 为 key 存储到map 中
        for (CategoryTreeVo categoryTreeVo : treeList) {
            map.put(categoryTreeVo.getId(), categoryTreeVo);
        }

        List<CategoryTreeVo> list = new ArrayList<>();
        CategoryTreeVo parentTree = null;
        for (CategoryTreeVo tree : treeList) {
            //子集ID返回对象，有则添加。
            parentTree = map.get(tree.getPid());
            if (parentTree != null) {
                parentTree.getChild().add(tree);
            } else {
                list.add(tree);
            }
        }

        return list;
    }

    public static final boolean isCondition(S_category tempCategory
            , Integer type, Integer status, String name, List<Integer> categoryIdList, int owner){
        if(owner != tempCategory.getOwner().intValue()){
            return false;
        }
        if(type != null && type.intValue() != tempCategory.getType().intValue()){
            return false;
        }
        if(status != null && status.intValue() >= 0 && status.intValue() != tempCategory.getStatus().intValue()){
            return false;
        }
        if(!StringUtils.isEmptyList(categoryIdList) && !categoryIdList.contains(tempCategory.getId())){
            logger.debug("不包含在给定的集合中'categoryIdList'");
            return false;
        }
        return true;
    }

    public static final CategoryTreeVo toCategoryTreeVo(S_category category){
        CategoryTreeVo categoryTreeVo = new CategoryTreeVo();
        categoryTreeVo.setId(category.getId());
        categoryTreeVo.setName(category.getName());
        categoryTreeVo.setPid(category.getPid());
        categoryTreeVo.setExtra(category.getExtra());
        categoryTreeVo.setPath(category.getPath());
        categoryTreeVo.setSort(category.getSort());
        categoryTreeVo.setStatus(category.getStatus() == 1);
        categoryTreeVo.setType(category.getType());
        categoryTreeVo.setUrl(category.getUrl());
        return categoryTreeVo;
    }

}
