package com.iplatform.base.util;

import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.core.RegularConstants;
import com.walker.infrastructure.utils.PhoneNumberUtils;
import com.walker.infrastructure.utils.StringUtils;

import java.util.regex.Pattern;

/**
 * 配置表单验证工具。后续要合并到平台。
 * @author 时克英
 * @date 2023-05-20
 */
public class ConfigFormValidateUtils {

    /**
     * 手机
     * @param value String 值
     * @param info String 字段名
     */
    public static void isPhone(String value, String info) {
        regularException(value, info, RegularConstants.PHONE_TWO, "手机");
    }

    /**
     * 验证必填
     * @param value String 值
     * @param info String 字段名

     * @since 2020-05-11
     */
    public static void isRequire(String value, String info){
        if(StringUtils.isEmpty(value) ){
            throw new PlatformRuntimeException("请填写/选择" + info);
        }
    }

    /**
     * 正则表达式验证
     * @param value String 值
     * @param info String 字段名
     * @param regular String 正则表达式

     * @since 2020-05-11
     */
    public static void regularException(String value, String info, String regular, String title){
        if(!regular(value, info, regular)){
            //正则验证
            throw new PlatformRuntimeException(info + " 格式必须为 " + title);
        }
    }

    /**
     * 正则表达式验证
     * @param value String 值
     * @param info String 字段名
     * @param regular String 正则表达式

     * @since 2020-05-11
     */
    public static boolean regular(String value, String info, String regular){
        isRequire(value, info);
        Pattern pattern = Pattern.compile(regular);
        return pattern.matcher(value).matches();
    }

    /**
     * 校验是否是手机号，不是则抛出异常
     * @param phone 手机号
     */
    public static void isPhoneException(String phone) {
//        boolean match = false;
//        if(StringUtils.isEmpty(phone)){
//            match = false;
//        }
//        boolean match = ReUtil.isMatch(RegularConstants.PHONE_TWO, phone);
        boolean match = PhoneNumberUtils.isCellPhoneNumber(phone);
        if (!match) {
            throw new PlatformRuntimeException("请输入正确的手机号");
        }
    }
}
