package com.iplatform.base.util;

import com.iplatform.base.Constants;
import com.iplatform.base.support.DeptTreeGenerator;
import com.iplatform.base.util.dept.SystemDept;
import com.iplatform.model.po.S_dept;
import com.walker.infrastructure.tree.TreeNode;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class DeptUtils {

    public static final String KEY_CHILDREN_PREFIX = ".children";

    public static S_dept SUPER_VISOR_DEPT = null;

    static {
        S_dept dept = new S_dept();
        dept.setId(0L);
        dept.setDept_name(Constants.SUPERVISOR_NAME_ZH);
        dept.setOrg_id(Constants.SUPERVISOR_ID);
        dept.setOrg_type(0);
        SUPER_VISOR_DEPT = dept;
    }

    /**
     * 生成一个顶级机构树结构对象，用于前端渲染。<p></p>
     * 目前使用在添加机构、用户，选择部门界面。
     * @param orgList 原始机构列表
     * @return
     * @date 2022-12-12
     */
    public static final List<TreeNode> getOrgDeptTree(List<S_dept> orgList){
        DeptTreeGenerator deptTreeGenerator = new DeptTreeGenerator(null);
        deptTreeGenerator.setEntityList(orgList);
        List<TreeNode> treeNodeList = deptTreeGenerator.getTreeRootList();
        return treeNodeList;
    }

    public static final List<SystemDept> toSystemDeptList(List<S_dept> deptList){
        if(StringUtils.isEmptyList(deptList)){
            return null;
        }
        List<SystemDept> systemDeptList = new ArrayList<>(32);
        for(S_dept dept : deptList){
            systemDeptList.add(toSystemDept(dept));
        }
        return systemDeptList;
    }

    public static final SystemDept toSystemDept(S_dept s_dept){
        return new SystemDept(s_dept);
    }
}
