package com.iplatform.base.util;

import com.iplatform.base.util.menu.SystemMenu;
import com.iplatform.model.po.S_menu;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

public class MenuUtils {

    /**
     * 菜单范围与给定的输入参数不匹配。
     * <pre>
     *     1) 把代码抽出来复用，根据用户登录所属身份（平台、独立机构、其他特定个人等）加载不同菜单。
     * </pre>
     * @param menuScope 菜单范围，参见常量
     * @param menu 菜单对象
     * @return 如果返回 true 表示不匹配，false 表示匹配
     * @date 2023-10-24
     */
    public static final boolean menuScopeNotMatch(int menuScope, S_menu menu){
        // 2023-10-11 增加这个if判断，如果是不区分范围，则加载所有菜单
        if(menuScope != MenuUtils.MENU_SCOPE_ALL){

            if(menuScope == MenuUtils.MENU_SCOPE_PLATFORM){
                // 如果要展示菜单范围是：平台，则菜单中 >= 4的分类都不要，这些是顶级机构业务独立菜单。
                if(menu.getType().intValue() >= MenuUtils.MENU_SCOPE_ORG){
                    return true;
                }
            } else if(menuScope == MenuUtils.MENU_SCOPE_ORG){
//                    if(menu.getType().intValue() < MenuUtils.MENU_SCOPE_ORG){
                if(menu.getType().intValue() != MenuUtils.MENU_SCOPE_ORG){
                    // 如果要展示菜单范围是：顶级机构业务的独立菜单，则平台菜单不显示。2023-06-01
                    return true;
                }
            } else if(menuScope > MenuUtils.MENU_SCOPE_ORG){
                // 对于大于机构菜单的，都属于机构特定菜单，必须与传入范围完全一致，如：班主任菜单等。2023-10-24
                if(menu.getType().intValue() != menuScope){
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean containMenu(List<SystemMenu> menuList, String menuId){
        for(SystemMenu systemMenu : menuList){
            if(systemMenu.getMenu_id().equals(menuId)){
                return true;
            }
        }
        return false;
    }

    /**
     * 获取组件信息（若依前端使用），方法已废弃。
     *
     * @param menu 菜单信息
     * @return 组件信息
     */
    @Deprecated
    public static String getComponent(SystemMenu menu) {
        String component = LAYOUT;
        if (StringUtils.isNotEmpty(menu.getComponent()) && !isMenuFrame(menu)) {
            component = menu.getComponent();
        }
        else if (StringUtils.isEmpty(menu.getComponent()) && menu.getParent_id().equals(MENU_ID_ROOT) && isInnerLink(menu)) {
            component = INNER_LINK;
        }
        else if (StringUtils.isEmpty(menu.getComponent()) && isParentView(menu)) {
            component = PARENT_VIEW;
        }
        return component;
    }

    /**
     * 是否为parent_view组件。<p></p>
     * 个人理解: 菜单有上级目录，而且是一个目录菜单。(也就是中间目录菜单)
     *
     * @param menu 菜单信息
     * @return 结果
     */
    @Deprecated
    public static boolean isParentView(SystemMenu menu) {
        return !menu.getParent_id().equals(MENU_ID_ROOT) && MENU_TYPE_FOLDER.equals(menu.getMenu_type());
    }

    /**
     * 获取路由地址
     *
     * @param menu 菜单信息
     * @return 路由地址
     */
    @Deprecated
    public static String getRouterPath(SystemMenu menu) {
        String routerPath = menu.getPath();
        // 内链打开外网方式
        if (menu.getParent_id().equals(MENU_ID_ROOT) && isInnerLink(menu)) {
            routerPath = innerLinkReplaceEach(routerPath);
            return routerPath;
        }
        // 非外链并且是一级目录（类型为目录）
        if (menu.getParent_id().equals(MENU_ID_ROOT)
                && MENU_TYPE_FOLDER.equals(menu.getMenu_type())
                && menu.getIs_frame().intValue() == MENU_FRAME_NO) {
            routerPath = "/" + menu.getPath();
        }
        // 非外链并且是一级目录（类型为菜单）
        else if (isMenuFrame(menu)) {
            routerPath = "/";
        }
        /**else if(menu.getMenu_type().equals(MENU_TYPE_ITEM) || menu.getMenu_type().equals(MENU_TYPE_BUTTON)){
            // 有效的菜单项或者按钮权限，2022-11-18，时克英
            String perms = menu.getPerms();
            if(StringUtils.isNotEmpty(perms)){
                routerPath = acquireUrlFromPerms(perms);
            }
        }*/
        return routerPath;
    }

    /**
     * 是否为内链组件
     *
     * @param menu 菜单信息
     * @return 结果
     */
    public static boolean isInnerLink(SystemMenu menu) {
        return menu.getIs_frame().intValue() == MENU_FRAME_NO && StringUtils.isHttpLink(menu.getPath());
    }

    /**
     * 内链域名特殊字符替换
     *
     * @return
     */
    public static String innerLinkReplaceEach(String path) {
        return org.apache.commons.lang3.StringUtils.replaceEach(path
                , new String[] { StringUtils.NAME_HTTP, StringUtils.NAME_HTTPS },
                new String[] { "", "" });
    }

    /**
     * 获取路由名称
     *
     * @param menu 菜单信息
     * @return 路由名称
     */
    public static String getRouteName(SystemMenu menu) {
        // 首字母大写
        String routerName = StringUtils.capitalize(menu.getPath());
        // 非外链并且是一级目录（类型为目录）
        if (isMenuFrame(menu)) {
            routerName = StringUtils.EMPTY_STRING;
        }
        return routerName;
    }

    /**
     * 是否为菜单内部跳转。<p></p>
     * 个人理解: 当该菜单无上级目录，同时是'菜单项'时，而且 in_frame = 1(否)
     *
     * @param menu 菜单信息
     * @return 结果
     */
    public static boolean isMenuFrame(SystemMenu menu) {
        return menu.getParent_id().equals(MENU_ID_ROOT)
                && MENU_TYPE_ITEM.equals(menu.getMenu_type())
                && menu.getIs_frame().intValue() == MENU_FRAME_NO;
    }

    /**
     * 把菜单字段中的权限标识(perms)转换成URL请求路径。<p></p>
     * <pre>
     *     1)这是若依系统使用的方式，但需要手动(在源码中)配置每个请求的权限标识，因此要减少配置就要改掉。
     *     2)对于其中带query的权限，需要转换成(/*)以匹配rest方式按照id访问。
     *     3)其他的基本上按照路径分隔即可，如: system:role:list --> /system/role/list
     * </pre>
     * @param perms
     * @return
     * @date 2022-11-02
     * @author 时克英
     */
    public static final String acquireUrlFromPerms(String perms){
        if(StringUtils.isEmpty(perms)){
            throw new IllegalArgumentException("perms is required!");
        }
        String[] segments = perms.split(StringUtils.SEPARATOR_COLON);
        StringBuilder sb = new StringBuilder(StringUtils.FOLDER_SEPARATOR);
        for(int i=0; i<segments.length; i++){
            if(i > 0){
                sb.append(StringUtils.FOLDER_SEPARATOR);
            }
            if(segments[i].equals(SECURITY_NAME_QUERY)){
                sb.append("*");
            } else {
                sb.append(segments[i]);
            }
        }
        return sb.toString();
    }

    public static final String SECURITY_NAME_QUERY = "query";

    /**
     * 菜单类型: 目录，菜单项，功能按钮
     */
    public static final String MENU_TYPE_FOLDER = "M";
    public static final String MENU_TYPE_ITEM = "C";
    public static final String MENU_TYPE_BUTTON = "F";
    /**
     * 新界面，按钮菜单类型。
     * @date 2023-05-12
     */
    public static final String MENU_TYPE_POINT = "A";

    public static final String MENU_ID_ROOT = "0";

    public static final String MENU_VISIBLE = "0";
    public static final String MENU_INVISIBLE = "1";

    public static final int MENU_CACHE_ENABLE = 0;
    public static final int MENU_CACHE_DISABLE = 1;
    public static final int MENU_FRAME_YES = 0;
    public static final int MENU_FRAME_NO = 1;

//    public static final String MENU_STATUS_ENABLED = "0";
//    public static final String MENU_STATUS_DISABLED = "1";
    /**
     * 菜单状态：0 可用
     * @date 2023-10-13
     */
    public static final int MENU_STATUS_ENABLED = 0;
    /**
     * 菜单状态：1 禁用
     * @date 2023-10-13
     */
    public static final int MENU_STATUS_DISABLED = 1;

    /** Layout组件标识 */
    public final static String LAYOUT = "Layout";

    /** ParentView组件标识 */
    public final static String PARENT_VIEW = "ParentView";

    /** InnerLink组件标识 */
    public final static String INNER_LINK = "InnerLink";

    /**
     * 菜单范围：顶级机构菜单（或商户菜单），只有业务机构自己才能看到。
     * @date 2023-06-01
     */
    public static final int MENU_SCOPE_ORG = 4;

    /**
     * 菜单范围：平台菜单，只要单位字段（menu_type == 0）的都只显示平台菜单。
     * @date 2023-06-01
     */
    public static final int MENU_SCOPE_PLATFORM = 0;

    /**
     * 菜单范围：所有菜单，在某些场景下，需要显示任何菜单（如：邮政集团项目等，全网、基地）
     * @date 2023-10-11
     */
    public static final int MENU_SCOPE_ALL = -1;
}
