package com.iplatform.base.util;

import com.iplatform.base.config.PushProperties;
import com.iplatform.model.po.SfTemplateMessage;
import com.iplatform.model.vo.NotificationConfigVo;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.SmsMessage;
import com.walker.push.util.PushUtils;
import com.walker.push.wx.MessageTemplate;
import com.walker.push.wx.MessageValue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationUtils {

    public static final Notification acquireSmsNotification(String templateId
            , String userPhone, List<Variable> variableList, String title){
        Map<String, String> param = new HashMap<>(4);
        for(Variable variable : variableList){
            param.put(variable.getId(), variable.getStringValue());
        }
        SmsMessage smsMessage = new SmsMessage();
        smsMessage.setTemplateId(templateId);
        smsMessage.setTemplateParam(param);

        try {
            return PushUtils.acquireSmsNotification(title, JsonUtils.objectToJsonString(smsMessage), userPhone, "平台");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获得一个微信公众号提醒消息。
     * @param accessToken 基础 access_token
     * @param templateId 公众号消息模板ID
     * @param userOpenId 用户openId
     * @return
     * @date 2023-08-25
     */
    public static final Notification acquireWechatNotification(String accessToken
            , String templateId, String userOpenId, List<Variable> variableList){
        Notification notification = new Notification();
        notification.setId(NumberGenerator.getLongSequenceId());
        notification.setTitle("微信公众号推送");
        notification.setPersistent(true);
        notification.setFrom("平台");
        notification.setCreateTime(DateUtils.getDateTimeNumber());

        List<NotificationChannel> channels = new ArrayList<>(2);
        channels.add(NotificationChannel.OfficialAccount);
        notification.setChannelList(channels);

        List<String> accessTokenList = new ArrayList<>(2);
        accessTokenList.add(accessToken);
        notification.setReceiverList(accessTokenList);
        notification.setCreator("platform");
        notification.setParallel(false);

        //
        MessageTemplate messageTemplate = new MessageTemplate();
        messageTemplate.setTemplate_id(templateId);
        messageTemplate.setTouser(userOpenId);

        HashMap<String, MessageValue> param = new HashMap<>(4);
        for(Variable variable : variableList){
            param.put(variable.getId(), new MessageValue(variable.getStringValue()));
        }
        messageTemplate.setData(param);
        try {
            notification.setContent(JsonUtils.objectToJsonString(messageTemplate));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return notification;
    }

    public static final NotificationConfigVo acquireNotificationConfigVo(SfTemplateMessage templateMessage){
        NotificationConfigVo vo = new NotificationConfigVo();
        vo.setId(templateMessage.getId());
        vo.setName(templateMessage.getName());
        vo.setTempId(templateMessage.getTempId());
        vo.setTempKey(templateMessage.getTempKey());
        vo.setContent(templateMessage.getContent());
//        vo.setStatus();
        return vo;
    }

//    /**
//     * 平台业务通知可用的通道集合，我们会尝试每个通道，只要一个成功就不再发送。
//     * @date 2023-04-25
//     */
//    public static final List<NotificationChannel> platformNotificationTypes = new ArrayList<>(4);
//    static {
//        platformNotificationTypes.add(NotificationChannel.WebSocket);
//        platformNotificationTypes.add(NotificationChannel.Tcp);
//        platformNotificationTypes.add(NotificationChannel.System);
//    }

    /**
     * 解析推送普通消息配置的规则。详细参考：{@linkplain PushProperties#getMessageType()}
     * @param messageType
     * @return
     * @date 2023-04-26
     */
    public static final Object[] acquireMessagePushRules(String messageType){
        if(StringUtils.isEmpty(messageType)){
            return null;
        }
        messageType = messageType.replace(StringUtils.CHAR_SPACE, StringUtils.EMPTY_STRING);

        Object[] data = new Object[2];
        String[] indexList = null;
        if(messageType.indexOf("&&") > 0){
            data[0] = true;
            indexList = messageType.split("&&");

        } else if(messageType.indexOf("||") > 0){
            data[0] = false;
            indexList = messageType.split("\\|\\|");
        } else {
            data[0] = false;
            indexList = new String[]{messageType};
        }
        data[1] = indexList;

        return data;
    }

    /**
     * 获取发送短信验证码通知
     * @param templateId 模板ID
     * @param code 验证码
     * @param targetUserId 目标用户ID
     * @param creator 创建人ID
     * @return
     * @date 2023-04-25
     */
    public static final Notification acquireSmsValidateCode(String templateId
            , String code, String targetUserId, String creator){
        Map<String, String> param = new HashMap<>(2);
        param.put("code", code);
        return acquireSmsNotification(templateId, param, "发送验证码", targetUserId, creator);
    }

    public static final Notification acquireSmsNotification(String templateId
            , Map<String, String> param, String title, String targetUserId, String creator){
        SmsMessage smsMessage = new SmsMessage();
        smsMessage.setTemplateId(templateId);
        smsMessage.setTemplateParam(param);

        try {
            return PushUtils.acquireSmsNotification(title, JsonUtils.objectToJsonString(smsMessage), targetUserId, creator);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
