package com.iplatform.base.util;

import com.iplatform.core.util.AESUtils;
import com.walker.infrastructure.utils.Base64;
import com.walker.infrastructure.utils.Base64Utils;
import com.walker.infrastructure.utils.RSAUtil;
import com.walker.infrastructure.utils.StringUtils;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;

public class PlatformRSAUtils {

    /**
     * 使用公共密钥，解密密码数据。<p>目前APP端使用（电商）</p>
     * @param encryptString
     * @return
     * @date 2023-07-11
     */
    public static final String getAesDecryptValue(String encryptString){
        if(StringUtils.isEmpty(encryptString)){
            throw new IllegalArgumentException("加密后密码不能为空");
        }
        return AESUtils.decryptStrAES(encryptString, AES_KEY);
    }

    /**
     * 返回加密之前的原始内容（解密原始字符串）
     * @param encryptString 加密的内容（RSA）
     * @param privateKeyString 私钥字符串
     * @return
     * @date 2023-03-20
     */
    public static final String getRsaDecryptValue(String encryptString, String privateKeyString){
        PrivateKey privateKey = getRsaPrivateKey(privateKeyString);
        if(privateKey == null){
            throw new IllegalStateException("通过私钥字符串生成'PrivateKey'异常!");
        }
        return RSAUtil.decrypt(privateKey, Base64.decode(encryptString.getBytes()));
    }

    /**
     * 根据私钥字符串，生成对应的私钥对象。<br>RSA标准算法，PKCS8EncodedKeySpec
     * @param privateKeyString
     * @return
     * @date 2023-03-20
     */
    public static final PrivateKey getRsaPrivateKey(String privateKeyString){
        try{
            byte[] keyBytes = Base64Utils.decode(privateKeyString);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            return privateK;

        } catch (Exception ex){
            ex.printStackTrace();
            return null;
        }
    }

    public static final String AES_KEY = "MIGfMA0GCSqGSIb3";

    private static final String PUBK = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDffJ9KczIXi+nsa2Sib3rLnZ5R\n" +
            "yhlY5enEhZTQc1GcTeZb6gqu4HoDJV6lskfexSNCUC/3mmNj2nruWGgRg6iVCAMB\n" +
            "Uf5oMv5nVqIhZ5davy1UZ9yvwL0+yVhBSXmamUmezQlh0H3clUI1N3Hc9aCiulB6\n" +
            "RMIsv1aukBkTBhgQZQIDAQAB";
    public static final String PRIK = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAN98n0pzMheL6exr\n" +
            "ZKJvesudnlHKGVjl6cSFlNBzUZxN5lvqCq7gegMlXqWyR97FI0JQL/eaY2Paeu5Y\n" +
            "aBGDqJUIAwFR/mgy/mdWoiFnl1q/LVRn3K/AvT7JWEFJeZqZSZ7NCWHQfdyVQjU3\n" +
            "cdz1oKK6UHpEwiy/Vq6QGRMGGBBlAgMBAAECgYBEyOuSE5CIVMTjwk4P/LXTs6iF\n" +
            "zektRl5D4UVjPwsQS52qDofJOUf0be0KnKuoMg7fGyUYVUlf81/Aui8VrOsWmEbU\n" +
            "8XL41Pi3m6EWWGeWE1/5q+j29jxYrrhfBcpBH/4fBKMhiNJ+jnJ2bH+TpngRwpNe\n" +
            "nVIfxRU5FdHOL3WNIQJBAPKGUSOgynf82LEQfvpzzp8gqhGMVbnVIqtezUNPQyK2\n" +
            "da7ryWYP88SE38JhB6GlM6bimCWRgIzodydccuJTd50CQQDr54J5upPlMsR3im0Q\n" +
            "qCeVbrGfn+DO226cZMaUhbVwxY7xy4ewXyt4yY6vBxwYX7GYs24jZPKekyWDeqr2\n" +
            "UrVpAkBmXJSwkfQC8sBO86R0dx6VgUbmwzGHjtLkO84tA65VX2eKXdCSeFct8dsz\n" +
            "gpqi+kQzwt3utVvpnVB1V4rRxeLtAkEAm/2SQXwmn8BaOdHHHOSUiDOSMMM/nIlt\n" +
            "Mu1QgpWHzPJV+31iVDYaQNzHBOXmphdhEGBVzAHMjR8wByjuM8OtQQJBAM8pK710\n" +
            "JC6YzfchqlNMFRh6kieWEx+o+aoWtL0EmeHB56nF96QHPW09UAP2VRUdadgSD+1w\n" +
            "Zmw/rOnAk8t/ryg=";
}
