package com.iplatform.base.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

public class RestTemplateUtils {

    protected static final Logger logger = LoggerFactory.getLogger(RestTemplateUtils.class);

    /**
     * 请求远程调用，输入xml格式数据
     * @param url
     * @param xml
     * @param restTemplate
     * @return
     * @date 2023-08-10
     */
    public static final String postXml(String url, String xml, RestTemplate restTemplate){
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/xml; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity<String> requestEntity = new HttpEntity<>(xml, headers);
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, requestEntity, String.class);
        try{
            logger.debug("responseEntity = "+responseEntity);
            return responseEntity.getBody();
//            return new String(Objects.requireNonNull(responseEntity.getBody()).getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        }catch (Exception e){
            logger.error("postXml异常，url=" + url + ", " + e.getMessage(), e);
            return null;
        }
    }

    /**
     * 发送GET请求
     * @param url 请求地址
     * @param restTemplate
     * @return
     * @date 2023-07-16
     * @date 2023-08-10 方法抽象的不好，废弃。
     */
    @Deprecated
    public static final ObjectNode getData(String url, RestTemplate restTemplate) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
//        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>( headers);
        ResponseEntity<ObjectNode> response = restTemplate.exchange( url, HttpMethod.GET, requestEntity, ObjectNode.class);
        logger.debug(response.toString());
        return response.getBody();
    }
}
