package com.iplatform.base.util;

import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class TextUtils {

    public static List<Long> stringToLongArrayByRegex(String str, String regex) {
        List<Long> list = new ArrayList<>(8);
        if (str.contains(regex)) {
            String[] split = str.split(regex);
            for (String value : split) {
                if (StringUtils.isNotEmpty(value)) {
                    list.add(Long.parseLong(value.trim()));
                }
            }
        } else {
            list.add(Long.parseLong(str));
        }
        return list;
    }

    /**
     * 字符串分割，转化为数组
     *
     * @param str   字符串
     * @param regex 分隔符有
     * @return List<Integer>

     * @date 2023-05-17
     */
    public static List<Integer> stringToArrayByRegex(String str, String regex) {
        List<Integer> list = new ArrayList<>();
        if (str.contains(regex)) {
            String[] split = str.split(regex);
            for (String value : split) {
                if (StringUtils.isNotEmpty(value)) {
                    list.add(Integer.parseInt(value.trim()));
                }
            }
        } else {
            list.add(Integer.parseInt(str));
        }
        return list;
    }

    /**
     * 给定字符串首字母大写。暂时未使用，仍然用 apache-common 包。
     * @param str
     * @return
     */
    @Deprecated
    public static String capitalize(String str) {
        final int strLen = length(str);
        if (strLen == 0) {
            return str;
        }

        final int firstCodepoint = str.codePointAt(0);
        final int newCodePoint = Character.toTitleCase(firstCodepoint);
        if (firstCodepoint == newCodePoint) {
            // already capitalized
            return str;
        }

        final int[] newCodePoints = new int[strLen]; // cannot be longer than the char array
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint; // copy the first codepoint
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; ) {
            final int codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint; // copy the remaining ones
            inOffset += Character.charCount(codepoint);
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

}
