package com.iplatform.base.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iplatform.base.Constants;
import com.iplatform.base.DefaultUserPrincipal;
import com.iplatform.base.SecuritySpi;
import com.iplatform.base.pojo.UserInfo;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.DataStatus;
import com.walker.web.UserPrincipal;
import com.walker.web.UserType;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UserUtils {

    /**
     * 返回前端（PC）用户基本信息，电商系统使用该对象。
     * @param user_core
     * @param token
     * @return
     * @date 2023-05-12
     */
    public static final UserInfo acquireClientUserInfo(S_user_core user_core, String token){
        UserInfo userInfo = new UserInfo();
        userInfo.setAccount(user_core.getUser_name());
        userInfo.setRealName(user_core.getNick_name());
        userInfo.setToken(token);
        userInfo.setIsSms(false);
        return userInfo;
    }

    public static DefaultUserPrincipal SUPER_VISOR = null;

    /**
     * 正式代码，创建超级管理员用户登录对象
     * @return
     */
    public static final UserPrincipal<S_user_core> createSupervisor(String supervisorPassword){
        if(SUPER_VISOR != null){
            return SUPER_VISOR;
        }

        S_user_core userCore = new S_user_core();
        userCore.setId(Constants.SUPERVISOR_ID);
//        userCore.setCreateTime(DateUtils.getDateTimeNumber(System.currentTimeMillis()));
        userCore.setCreate_time(DateUtils.getDateTimeNumber(System.currentTimeMillis()));
        userCore.setStatus(DataStatus.CONST_NORMAL);
        userCore.setUser_name(Constants.SUPERVISOR_NAME_DEFAULT);
        userCore.setNick_name(Constants.SUPERVISOR_NAME_ZH);
//        userCore.setPassword("123456"); // 这里要修改，应该存储加密过后的密码信息
        userCore.setPassword(supervisorPassword);
        userCore.setUser_type(UserType.TYPE_SUPER);
        userCore.setOrg_id(Constants.SUPERVISOR_ID);
        userCore.setDept_id(Constants.SUPERVISOR_ID);
        userCore.setMer_id(Constants.SUPERVISOR_ID);
        userCore.setModify_pwd(1);
        userCore.setIs_sms(0);
        userCore.setType(0);
        userCore.setProfile_id(Constants.SUPERVISOR_ID);
        userCore.setIs_wechat_android(0);
        userCore.setIs_wechat_ios(0);
        userCore.setIs_wechat_routine(0);
        userCore.setIs_wechat_public(0);
        userCore.setBind_mail(0);
        userCore.setBind_mobile(0);
        userCore.setBind_wechat(0);
        userCore.setBind_client_id("client_id");

        DefaultUserPrincipal userPrincipal = new DefaultUserPrincipal(userCore);
        SUPER_VISOR = userPrincipal;
        return SUPER_VISOR;
    }

    /**
     * 工具方法: 返回当前登录用户对象。
     * @return
     * @date 2023-02-14
     */
    public static final S_user_core getUserInfo(){
        return BeanContextAware.getBeanByType(SecuritySpi.class).getCurrentUser();
    }

    /**
     * 返回当前登录用户，如果不存在返回：null
     * @return
     * @date 2023-08-01
     */
    public static final UserPrincipal<S_user_core> getCurrentUserPrincipal(){
        return BeanContextAware.getBeanByType(SecuritySpi.class).getCurrentUserPrincipal();
    }

    /**
     * 把用户缓存json字符串转换成对象。
     * @param userJson
     * @return
     * @throws Exception
     * @date 2022-12-30
     */
    public static final DefaultUserPrincipal toUserPrincipal(String userJson) throws Exception{
        ObjectNode objectNode = JsonUtils.jsonStringToObjectNode(userJson);
        return createUserPrincipal(objectNode);
    }

    private static final DefaultUserPrincipal createUserPrincipal(ObjectNode objectNode){
        JsonNode userInfoNode = objectNode.get("userInfo");
        S_user_core user_core = new S_user_core();
        user_core.setId(userInfoNode.get("id").asLong());
        user_core.setUser_name(userInfoNode.get("user_name").asText());
        user_core.setPassword(userInfoNode.get("password").asText());
        user_core.setDept_id(userInfoNode.get("dept_id").asLong());
        user_core.setNick_name(userInfoNode.get("nick_name").asText());
        user_core.setUser_type(userInfoNode.get("user_type").asInt());
        user_core.setCreate_time(userInfoNode.get("create_time").asLong());
        user_core.setOrg_id(userInfoNode.get("org_id").asLong());
        user_core.setStatus(userInfoNode.get("status").asInt());
        user_core.setDel_flag(userInfoNode.get("del_flag").asInt());
        if(!JsonUtils.isEmptyObject(userInfoNode.get("sex"))){
            user_core.setSex(userInfoNode.get("sex").asText());
        } else {
            user_core.setSex("2");
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("phonenumber"))){
            user_core.setPhonenumber(userInfoNode.get("phonenumber").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("avatar"))){
            user_core.setAvatar(userInfoNode.get("avatar").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("email"))){
            user_core.setEmail(userInfoNode.get("email").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("remark"))){
            user_core.setRemark(userInfoNode.get("remark").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("create_by"))){
            user_core.setCreate_by(userInfoNode.get("create_by").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("login_date"))){
            user_core.setLogin_date(userInfoNode.get("login_date").asLong());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("login_ip"))){
            user_core.setLogin_ip(userInfoNode.get("login_ip").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("update_by"))){
            user_core.setUpdate_by(userInfoNode.get("update_by").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("update_time"))){
            user_core.setUpdate_time(userInfoNode.get("update_time").asLong());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("wx_open_id"))){
            user_core.setWx_open_id(userInfoNode.get("wx_open_id").toString());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("wx_union_id"))){
            user_core.setWx_union_id(userInfoNode.get("wx_union_id").toString());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("ding_user_id"))){
            user_core.setDing_user_id(userInfoNode.get("ding_user_id").toString());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("bind_client_id"))){
            user_core.setBind_client_id(userInfoNode.get("bind_client_id").toString());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("bind_wechat"))){
            user_core.setBind_wechat(userInfoNode.get("bind_wechat").intValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("modify_pwd"))){
            user_core.setModify_pwd(userInfoNode.get("modify_pwd").intValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("bind_mobile"))){
            user_core.setBind_mobile(userInfoNode.get("bind_mobile").intValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("bind_mail"))){
            user_core.setBind_mail(userInfoNode.get("bind_mail").intValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("profile_id"))){
            user_core.setProfile_id(userInfoNode.get("profile_id").longValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("is_wechat_public"))){
            user_core.setIs_wechat_public(userInfoNode.get("is_wechat_public").intValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("is_wechat_routine"))){
            user_core.setIs_wechat_routine(userInfoNode.get("is_wechat_routine").intValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("is_wechat_ios"))){
            user_core.setIs_wechat_ios(userInfoNode.get("is_wechat_ios").intValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("is_wechat_android"))){
            user_core.setIs_wechat_android(userInfoNode.get("is_wechat_android").intValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("is_sms"))){
            user_core.setIs_sms(userInfoNode.get("is_sms").intValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("mer_id"))){
            user_core.setMer_id(userInfoNode.get("mer_id").longValue());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("type"))){
            user_core.setType(userInfoNode.get("type").intValue());
        }
        JsonNode roleIdListJson = objectNode.get("roleIdList");
        List<String> roleList = new ArrayList<>(4);
        if(roleIdListJson.isArray()){
            for(Iterator<JsonNode> it = roleIdListJson.iterator(); it.hasNext();){
                roleList.add(it.next().asText());
            }
        }

        DefaultUserPrincipal defaultUserPrincipal = new DefaultUserPrincipal(user_core);
        defaultUserPrincipal.setRoleIdList(roleList);

        // 2022-12-21
        JsonNode dataScopeMap = objectNode.get("dataScopeMap");
        if(dataScopeMap != null){
            String functionMenuId = null;
            for(Iterator<String> it = dataScopeMap.fieldNames(); it.hasNext();){
                functionMenuId = it.next();
                defaultUserPrincipal.addDataScope(functionMenuId, dataScopeMap.get(functionMenuId).asText());
            }
        }

        return defaultUserPrincipal;
    }

    /**
     * 把角色ID字符串集合转成数值集合。
     * @param roleIds
     * @return
     */
    public static final List<Long> toRoleIdLongList(List<String> roleIds){
        if(StringUtils.isEmptyList(roleIds)){
            return null;
        }
        List<Long> roleList = new ArrayList<>(4);
        for(String roleId : roleIds){
            roleList.add(Long.parseLong(roleId));
        }
        return roleList;
    }
}
