package com.iplatform.base.util;

import com.iplatform.base.PlatformRuntimeException;
import com.walker.infrastructure.utils.Base64Utils;
import com.walker.infrastructure.utils.FileCopyUtils;
import com.walker.infrastructure.utils.StringUtils;

import javax.imageio.ImageIO;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
//import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * 移植对象，拼图滑块对象处理工具，后续需要重构优化。
 * @author 时克英
 * @date 2023-04-06
 */
public class VerifyImgUtil {
    private static int T_WIDTH = 320;  //源文件宽度
    private static int T_HEIGHT = 180;  //源文件高度

    /*
     * @Author : liu.q [916000612@qq.com]
     * @Date : 2019-06-24 15:46
     * @Description : 随机生成抠图坐标
     */
    public static Map<String, Integer> generateCutoutCoordinates(int w, int h) {
        Map<String, Integer> result = new HashMap();
        int x = new SecureRandom().nextInt(T_WIDTH - w);
        int y = new SecureRandom().nextInt(T_HEIGHT - h);
        while (x < w + 10) {
            x = new SecureRandom().nextInt(275);
        }
        result.put("x", x);
        result.put("y", y);
        return result;
    }

    /*
     * @Author : liu.q [916000612@qq.com]
     * @Date : 2019-06-24 16:22
     * @Description :生成滑块
     */
    public static Map<String, BufferedImage> initSlidingBlock(BufferedImage sourceImg, int[][] templateImgData, int x, int y, int w, int h) throws Exception {
        // 支持alpha通道的rgb图像
        BufferedImage newTemplateImg = new BufferedImage(w, h, BufferedImage.TYPE_4BYTE_ABGR);

        for (int i = 0; i < templateImgData.length; i++) {
            for (int j = 0; j < templateImgData[0].length; j++) {
                int rgb = templateImgData[i][j];
                if (rgb == 1) {
                    int rgb_ori = sourceImg.getRGB(x + i, y + j);
                    int r = (0xff & rgb_ori);
                    int g = (0xff & (rgb_ori >> 8));
                    int b = (0xff & (rgb_ori >> 16));
                    rgb_ori = r + (g << 8) + (b << 16) + (255 << 24);
                    newTemplateImg.setRGB(i, j, rgb_ori);

                    //创建遮罩层
                    BufferedImage cover = new BufferedImage(10, 10, BufferedImage.TYPE_INT_RGB);
                    Graphics2D coverG2 = (Graphics2D) cover.getGraphics();
                    coverG2.setColor(Color.BLACK);
                    coverG2.fillRect(0, 0, 10, 10);
                    coverG2.dispose();
                    Graphics2D bgG2 = (Graphics2D) sourceImg.getGraphics();
                    //开启透明度
                    bgG2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_ATOP, 0.5f));
                    //描绘
                    bgG2.drawImage(cover, i + x, y + j, 1, 1, null);
                    //结束透明度
                    bgG2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER));
                    bgG2.dispose();
                }
                if (rgb == 0) {
                    //不用搭理
                }
                if (rgb == 2) {
                    //秒边
                    newTemplateImg.setRGB(i, j, 16777215);
                    sourceImg.setRGB(x + i, y + j, 16777215);
                }
            }
        }
        Map<String, BufferedImage> result = new HashMap<>();
        result.put("newTemplateImg", newTemplateImg);
        result.put("newSourceImg", sourceImg);
        return result;
    }


    /*
     * @Author : liu.q [916000612@qq.com]
     * @Date : 2019-06-21 15:37
     * @Description : 获取base64
     */
    public static String getBase64(BufferedImage bi) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String res = StringUtils.EMPTY_STRING;
        try {
            ImageIO.write(bi, "png", outputStream);
//            res = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            res = Base64Utils.encode(outputStream.toByteArray());
            res = "data:image/png;base64," + res;
        } catch (Exception e) {
            throw new PlatformRuntimeException("验证码图片传base64错误:" + e.getMessage(), e);
        } finally {
            try {
                outputStream.close();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return res;
    }

    /**
     * hash 转换
     *
     * @param base64 String 图片流
     * @return String

     * @since 2020-06-03
     */
    public static String getBase64Image(String base64) {
        return "data:image/png;base64," + base64;
    }

    /*
     * @Author : liu.q [916000612@qq.com]
     * @Date : 2019-06-24 17:22
     * @Description : 生成抠图图形矩阵
     */
    public static int[][] getTemplateData(BufferedImage bi) {
        int[][] data = new int[bi.getWidth()][bi.getHeight()];
        for (int i = 0; i < bi.getWidth(); i++) {
            for (int j = 0; j < bi.getHeight(); j++) {
                int rgb = bi.getRGB(i, j);
                int leftRgb = -1, rightRgb = -1, upRgb = -1, downRgb = -1;
                if (j > 0)
                    leftRgb = bi.getRGB(i, j - 1);
                if (j < bi.getHeight() - 1)
                    rightRgb = bi.getRGB(i, j + 1);
                if (i > 0)
                    upRgb = bi.getRGB(i - 1, j);
                if (i < bi.getWidth() - 1)
                    downRgb = bi.getRGB(i + 1, j);
                if (rgb == -1 && (i == 0 || i == bi.getWidth() - 1 || j == 0 || j == bi.getHeight() - 1)) {
                    data[i][j] = 2; //边
                } else if (rgb == -1 && (leftRgb != -1 || rightRgb != -1 || upRgb != -1 || downRgb != -1)) {
                    data[i][j] = 2;//边
                } else if (rgb == -1) {
                    data[i][j] = 1;//内容区域
                } else {
                    data[i][j] = 0;//透明区域
                }
            }
        }
        return data;
    }

    /**
     * base64 字符串转图片
     *
     * @param base64String
     * @return
     */
    public static BufferedImage getBase64StrToImage(String base64String) {
        ByteArrayInputStream inputStream = null;
        try {
//            Base64.Decoder decoder = Base64.getDecoder();
//            byte[] bytes = decoder.decode(base64String);
            byte[] bytes = Base64Utils.decode(base64String);
            inputStream = new ByteArrayInputStream(bytes);
            return ImageIO.read(inputStream);
        } catch (Exception e) {
            throw new PlatformRuntimeException("验证码base64转文件错误:" + e.getMessage(), e);
        } finally {
            if(inputStream != null){
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeBase64ToFile(String base64String, File outFile){
        BufferedOutputStream outputStream = null;
        try{
            byte[] bytes = Base64Utils.decode(base64String);
            outputStream = new BufferedOutputStream(new FileOutputStream(outFile));
            FileCopyUtils.copy(bytes, outputStream);
        }catch (Exception ex){
            throw new PlatformRuntimeException("文件base64保存文件错误:" + ex.getMessage() + ", file=" + outFile.getAbsolutePath(), ex);
        }
    }
}
