package com.iplatform.base.util.cache;

import com.iplatform.model.po.S_category;

import java.util.Comparator;

/**
 * 平台分类对象排序规则，缓存使用。
 * <p>order by sort desc, id asc</p>
 * @author 时克英
 * @date 2023-05-17
 */
public class CategorySortComparator implements Comparator<S_category> {

    @Override
    public int compare(S_category o1, S_category o2) {
        int sortNum = o2.getSort() - o1.getSort();
        if(sortNum != 0){
            return sortNum;
        }
        return o2.getId() - o1.getId();
    }
}
