/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base;

import com.iplatform.base.AbstractSecurityController;
import com.iplatform.base.FileOperateSpi;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.core.BeanContextAware;
import com.walker.file.FileInfo;
import com.walker.file.FileStoreType;
import com.walker.infrastructure.utils.FileCopyUtils;
import com.walker.infrastructure.utils.FileUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractFileOperateSpiController
extends AbstractSecurityController {
    protected FileOperateSpi acquireFileOperateSpi() {
        return (FileOperateSpi)BeanContextAware.getBeanByType(FileOperateSpi.class);
    }

    protected String clearCdnPrefix(String path) {
        return this.acquireFileOperateSpi().clearCdnPrefix(path);
    }

    protected String getCdnUrl() {
        return this.acquireFileOperateSpi().getCdnUrl();
    }

    protected byte[] getLocalFileData(FileInfo fileInfo) {
        String localRoot = this.acquireFileOperateSpi().getFileRootConfig();
        String absolutePath = localRoot + fileInfo.getUrl();
        try {
            return FileCopyUtils.copyToByteArray((File)new File(absolutePath));
        }
        catch (IOException e) {
            throw new RuntimeException("\u6587\u4ef6\u52a0\u8f7d\u5f02\u5e38\uff0c\u53ef\u80fd\u4e0d\u5b58\u5728:" + absolutePath, e);
        }
    }

    protected FileInfo getFileInfo(String id) {
        if (StringUtils.isEmpty((String)id)) {
            this.logger.warn("id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u6587\u4ef6\u4fe1\u606f");
            return null;
        }
        return this.acquireFileOperateSpi().getFileInfo(Long.parseLong(id));
    }

    protected List<FileInfo> getFileInfoList(List<String> ids) {
        if (StringUtils.isEmptyList(ids)) {
            throw new IllegalArgumentException("ids is required!");
        }
        return this.acquireFileOperateSpi().getFileInfoList(ids);
    }

    protected FileInfo uploadFileToLocal(InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner) throws Exception {
        return this.acquireFileOperateSpi().uploadFileToLocal(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    protected FileInfo[] uploadFileToLocal(InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws Exception {
        return this.acquireFileOperateSpi().uploadFileToLocal(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    protected FileInfo uploadFileToLocal(MultipartFile multipartFile, String groupId, Integer businessType, String owner, String fileContentType) throws Exception {
        this.checkMultipartFile(multipartFile);
        long fileSize = multipartFile.getSize();
        String fileName = multipartFile.getOriginalFilename().toLowerCase();
        if (fileName.length() > 99) {
            fileName = fileName.substring(fileName.length() - 99);
        }
        String fileExt = this.checkFile(fileName, fileSize, fileContentType);
        this.logger.debug("\u4e0a\u4f20\u672c\u5730\u6587\u4ef6\u6269\u5c55\u540d\uff1a" + fileExt);
        return this.uploadFileToLocal(multipartFile.getInputStream(), fileName, groupId, fileSize, businessType, owner);
    }

    protected FileInfo[] uploadFileToLocal(MultipartFile[] multipartFile, String groupId, Integer businessType, String owner, String fileContentType) throws Exception {
        if (multipartFile == null || multipartFile.length == 0) {
            throw new IllegalArgumentException("multipartFile\u6570\u7ec4\u4e3a\u7a7a");
        }
        int size = multipartFile.length;
        InputStream[] inputStream = new InputStream[size];
        String[] fileName = new String[size];
        long[] fileSize = new long[size];
        for (int i = 0; i < size; ++i) {
            inputStream[i] = multipartFile[i].getInputStream();
            fileName[i] = multipartFile[i].getOriginalFilename().toLowerCase();
            fileSize[i] = multipartFile[i].getSize();
        }
        return this.uploadFileToLocal(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    protected FileInfo uploadFileToRemote(InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner) throws Exception {
        String remoteFileStoreType = this.getArgumentVariable("uploadType").getStringValue();
        if (StringUtils.isEmpty((String)remoteFileStoreType)) {
            throw new PlatformRuntimeException("\u5e73\u53f0\u672a\u914d\u7f6e\u4efb\u4f55\u8fdc\u7a0b\u5b58\u50a8\u7c7b\u522b\uff1auploadType");
        }
        if (this.acquireFileOperateSpi().isRemoteAsLocal()) {
            return this.acquireFileOperateSpi().uploadFileToLocal(inputStream, fileName, groupId, fileSize, businessType, owner);
        }
        FileStoreType fileStoreType = FileStoreType.getType((String)remoteFileStoreType);
        if (fileStoreType == FileStoreType.Ftp) {
            return this.acquireFileOperateSpi().uploadFileToFtp(inputStream, fileName, groupId, fileSize, businessType, owner);
        }
        return this.acquireFileOperateSpi().uploadFileToOss(inputStream, fileName, groupId, fileSize, businessType, owner, fileStoreType);
    }

    protected FileInfo[] uploadFileToRemote(InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws Exception {
        String remoteFileStoreType = this.getArgumentVariable("uploadType").getStringValue();
        if (StringUtils.isEmpty((String)remoteFileStoreType)) {
            throw new PlatformRuntimeException("\u5e73\u53f0\u672a\u914d\u7f6e\u4efb\u4f55\u8fdc\u7a0b\u5b58\u50a8\u7c7b\u522b\uff1auploadType");
        }
        if (this.acquireFileOperateSpi().isRemoteAsLocal()) {
            return this.acquireFileOperateSpi().uploadFileToLocal(inputStream, fileName, groupId, fileSize, businessType, owner);
        }
        FileStoreType fileStoreType = FileStoreType.getType((String)remoteFileStoreType);
        if (fileStoreType == FileStoreType.Ftp) {
            return this.acquireFileOperateSpi().uploadFileToFtp(inputStream, fileName, groupId, fileSize, businessType, owner);
        }
        return this.acquireFileOperateSpi().uploadFileToOss(inputStream, fileName, groupId, fileSize, businessType, owner, fileStoreType);
    }

    protected FileInfo uploadFileToRemote(MultipartFile multipartFile, String groupId, Integer businessType, String owner, String fileContentType) throws Exception {
        this.checkMultipartFile(multipartFile);
        long fileSize = multipartFile.getSize();
        String fileName = multipartFile.getOriginalFilename().toLowerCase();
        String fileExt = this.checkFile(fileName, fileSize, fileContentType);
        this.logger.debug("\u4e0a\u4f20\u8fdc\u7a0b\u6587\u4ef6\u6269\u5c55\u540d\uff1a" + fileExt);
        return this.uploadFileToRemote(multipartFile.getInputStream(), fileName, groupId, fileSize, businessType, owner);
    }

    protected FileInfo[] uploadFileToRemote(MultipartFile[] multipartFile, String groupId, Integer businessType, String owner, String fileContentType) throws Exception {
        int size = multipartFile.length;
        InputStream[] inputStream = new InputStream[size];
        String[] fileName = new String[size];
        long[] fileSize = new long[size];
        for (int i = 0; i < size; ++i) {
            inputStream[i] = multipartFile[i].getInputStream();
            fileName[i] = multipartFile[i].getOriginalFilename().toLowerCase();
            fileSize[i] = multipartFile[i].getSize();
        }
        return this.uploadFileToRemote(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    private void checkMultipartFile(MultipartFile multipartFile) {
        if (multipartFile == null) {
            throw new PlatformRuntimeException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        long fileSize = multipartFile.getSize();
        if (fileSize <= 0L) {
            throw new PlatformRuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u9519\u8bef\uff1a" + fileSize);
        }
    }

    private String checkFile(String fileName, long fileSize, String fileContentType) {
        String fileExt = FileUtils.getFileExt((String)fileName);
        if (StringUtils.isEmpty((String)fileExt)) {
            throw new PlatformRuntimeException("\u4e0d\u5b58\u5728\u6587\u4ef6\u6269\u5c55\u540d\uff0c\u65e0\u6cd5\u4e0a\u4f20");
        }
        String extArrayConfig = null;
        extArrayConfig = fileContentType.equals("uploadf") ? this.getArgumentVariable("file_ext_str").getStringValue() : this.getArgumentVariable("image_ext_str").getStringValue();
        if (StringUtils.isNotEmpty((String)extArrayConfig)) {
            Set extensionList = StringUtils.commaDelimitedListToSet((String)extArrayConfig);
            if (extensionList == null || extensionList.size() == 0) {
                throw new PlatformRuntimeException("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\uff0c\u53ea\u80fd\u662f\uff1a" + extArrayConfig);
            }
            if (!extensionList.contains(fileExt)) {
                throw new PlatformRuntimeException("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\uff0c\u53ea\u80fd\u662f\uff1a" + extArrayConfig);
            }
        }
        long fileSizeConfig = 0L;
        fileSizeConfig = fileContentType.equals("uploadf") ? this.getArgumentVariable("file_max_size").getLongValue() : this.getArgumentVariable("image_max_size").getLongValue();
        if (fileSize > (fileSizeConfig = fileSizeConfig * 1024L * 1024L)) {
            throw new PlatformRuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\uff1a" + fileSize + "\uff0c\u8d85\u51fa\u9650\u5236\uff1a" + fileSizeConfig);
        }
        return fileExt;
    }

    @Deprecated
    protected FileInfo uploadFileToLocal(InputStream inputStream, String fileName, String groupId, long fileSize) throws Exception {
        return this.acquireFileOperateSpi().uploadFileToSystem(inputStream, fileName, groupId, fileSize);
    }

    @Deprecated
    protected FileInfo uploadFileToRemote(InputStream inputStream, String fileName, String groupId, long fileSize) throws Exception {
        if (inputStream == null) {
            throw new IllegalArgumentException("\u4e0a\u4f20ftp\u6587\u4ef6\u6d41\u4e3a\u7a7a!");
        }
        return this.acquireFileOperateSpi().uploadFileToFtp(inputStream, fileName, groupId, fileSize);
    }

    protected FileInfo uploadFileToRemote(String absoluteFilePath, Integer businessType, String owner) throws Exception {
        File uploadFile = this.checkAbsoluteFilePath(absoluteFilePath);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(uploadFile));
        return this.uploadFileToRemote(inputStream, uploadFile.getName(), null, uploadFile.getTotalSpace(), businessType, owner);
    }

    @Deprecated
    protected FileInfo uploadFileToRemote(String absoluteFilePath) throws Exception {
        File uploadFile = this.checkAbsoluteFilePath(absoluteFilePath);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(uploadFile));
        return this.acquireFileOperateSpi().uploadFileToFtp(inputStream, FileUtils.getFileNameWithoutPath((String)absoluteFilePath), null, uploadFile.getTotalSpace());
    }

    private File checkAbsoluteFilePath(String absoluteFilePath) throws Exception {
        if (StringUtils.isEmpty((String)absoluteFilePath)) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u5168\u8def\u5f84\u4e0d\u5b58\u5728!");
        }
        File uploadFile = new File(absoluteFilePath.toLowerCase());
        if (!uploadFile.exists()) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728, file=" + absoluteFilePath);
        }
        return uploadFile;
    }
}

