/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base;

import com.iplatform.base.AbstractController;
import com.iplatform.base.SecuritySpi;
import com.iplatform.base.config.SecurityUserProperties;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.utils.PasswordUtils;
import com.walker.web.UserPrincipal;
import java.util.List;

public abstract class AbstractSecurityController
extends AbstractController {
    protected String validatePasswordRule(String originPassword) {
        String error = PasswordUtils.filterText((String)originPassword);
        if (error != null) {
            return error;
        }
        int passLevelConfig = this.acquireSecurityUserProperties().getPassLevel();
        if (!PasswordUtils.validateComplex((String)originPassword, (int)passLevelConfig)) {
            return "\u5bc6\u7801\u7ea7\u522b\u8fc7\u4f4e\uff0c\u8bf7\u8f93\u5165\uff1a\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u4ee5\u53ca\u81f3\u5c11\u4e00\u79cd\u7279\u6b8a\u7b26\u53f7";
        }
        return null;
    }

    protected SecurityUserProperties acquireSecurityUserProperties() {
        return (SecurityUserProperties)BeanContextAware.getBeanByType(SecurityUserProperties.class);
    }

    @Deprecated
    protected void loginAsWorkflowRole() {
        this.acquireSecuritySpi().loginAsWorkflowRole();
    }

    protected boolean isSupervisor() {
        S_user_core user_core = this.getCurrentUser();
        if (user_core == null) {
            throw new IllegalStateException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u9519\u8bef\uff0c\u672a\u627e\u5230");
        }
        return user_core.getUser_type() == 0;
    }

    public List<String> getCurrentUserRoleIdList() {
        return this.acquireSecuritySpi().getCurrentUserRoleIdList();
    }

    public UserPrincipal<S_user_core> getCurrentUserPrincipal() {
        return this.acquireSecuritySpi().getCurrentUserPrincipal();
    }

    protected String getCurrentDataScope(String menuId) {
        UserPrincipal<S_user_core> userPrincipal = this.getCurrentUserPrincipal();
        return userPrincipal.getDataScope(menuId);
    }

    public S_user_core getCurrentUser() {
        return this.acquireSecuritySpi().getCurrentUser();
    }

    public long getCurrentUserId() {
        return this.acquireSecuritySpi().getCurrentUserId();
    }

    public String encryptPassword(String password) {
        return this.acquireSecuritySpi().encryptPassword(password);
    }

    public boolean matchesPassword(String rawPassword, String encodedPassword) {
        return this.acquireSecuritySpi().matchesPassword(rawPassword, encodedPassword);
    }

    private SecuritySpi acquireSecuritySpi() {
        return (SecuritySpi)BeanContextAware.getBeanByType(SecuritySpi.class);
    }
}

