/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base;

import com.walker.connector.Address;
import com.walker.connector.LocalAddress;
import com.walker.db.DatabaseType;
import com.walker.db.TableInfo;
import com.walker.db.page.GenericPager;
import com.walker.dbmeta.DatabaseMetaEngine;
import com.walker.dbmeta.FieldInfo;
import com.walker.dbmeta.support.DamengMetaEngine;
import com.walker.dbmeta.support.MySQLMetaEngine;
import com.walker.dbmeta.support.OracleMetaEngine;
import com.walker.dbmeta.support.PostgresMetaEngine;
import com.walker.dbmeta.support.SqlserverMetaEngine;
import com.walker.security.SystemLogMan;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocalDatabaseMetaEngine {
    private DatabaseMetaEngine engine;
    private LocalAddress localAddress;

    public void setLocalAddress(LocalAddress localAddress) {
        if (localAddress == null) {
            throw new IllegalArgumentException("LocalAddress \u5fc5\u987b\u63d0\u4f9b");
        }
        this.localAddress = localAddress;
        SystemLogMan.getInstance().checkMan();
    }

    public void setDatabaseType(DatabaseType databaseType) {
        if (databaseType == DatabaseType.DERBY) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\uff1a" + databaseType.name());
        }
        if (databaseType == DatabaseType.MYSQL) {
            this.engine = new MySQLMetaEngine();
        } else if (databaseType == DatabaseType.ORACLE) {
            this.engine = new OracleMetaEngine();
        } else if (databaseType == DatabaseType.POSTGRES) {
            this.engine = new PostgresMetaEngine();
        } else if (databaseType == DatabaseType.SQLSERVER) {
            this.engine = new SqlserverMetaEngine();
        } else if (databaseType == DatabaseType.DAMENG) {
            this.engine = new DamengMetaEngine();
        } else {
            throw new IllegalArgumentException("unsupported database type: " + databaseType.name());
        }
        System.out.println("\u521b\u5efa:" + this.engine.getClass().getName());
    }

    public List<FieldInfo> getFieldsObject(String tableName) {
        return this.engine.getFieldsObject((Address)this.localAddress, tableName);
    }

    public List<String> getTableNamesByLike(String tableNameLike) {
        return this.engine.getTableNamesByLike((Address)this.localAddress, tableNameLike);
    }

    public GenericPager<TableInfo> queryPageTableNamesByLike(String tableNameLike) {
        return this.engine.queryPageTableNamesByLike((Address)this.localAddress, tableNameLike);
    }

    public TableInfo queryOneTableInfo(String tableName) {
        ArrayList<String> tableList = new ArrayList<String>(2);
        tableList.add(tableName);
        Map map = this.engine.getTableRows((Address)this.localAddress, tableList);
        if (map == null || map.size() == 0) {
            return null;
        }
        return (TableInfo)map.get(tableName);
    }
}

