/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base;

import com.iplatform.base.PushData;
import com.iplatform.base.SystemController;
import com.iplatform.base.push.DefaultPushManager;
import com.iplatform.base.util.NotificationUtils;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.util.PushUtils;
import java.util.ArrayList;
import java.util.Map;

public abstract class PushController
extends SystemController {
    protected void pushSmsValidateCode(String code, String userIdOrMobile) {
        String creator = this.getCurrentUserPrincipal() == null ? "creator" : this.getCurrentUserPrincipal().getId();
        ((DefaultPushManager)this.getPushManager()).pushSmsValidateCode(code, userIdOrMobile, creator);
    }

    protected void pushSmsNotification(String templateCode, Map<String, String> param, String userIdOrMobile) {
        String creator = this.getCurrentUserPrincipal() == null ? "creator" : this.getCurrentUserPrincipal().getId();
        Notification notification = NotificationUtils.acquireSmsNotification(templateCode, param, null, userIdOrMobile, creator);
        this.getPushManager().pushSms(notification);
    }

    protected void pushMailNotification(String title, String content, String userIdOrMail) {
        if (StringUtils.isEmpty((String)title) || StringUtils.isEmpty((String)content) || StringUtils.isEmpty((String)userIdOrMail)) {
            throw new IllegalArgumentException("\u63a8\u9001\u90ae\u4ef6\u5931\u8d25\uff1a\u53c2\u6570\u4e3a\u7a7a!");
        }
        String creator = this.getCurrentUserPrincipal() == null ? "creator" : this.getCurrentUserPrincipal().getId();
        Notification notification = PushUtils.acquireEmailNotificationOne((String)title, (String)content, (String)((DefaultPushManager)this.getPushManager()).getMailFrom(), (String)userIdOrMail, (String)creator);
        this.getPushManager().push(notification, null);
    }

    protected void pushMessageNotification(PushData pushData) {
        if (pushData == null) {
            throw new IllegalArgumentException("pushData is null!");
        }
        if (StringUtils.isEmpty((String)pushData.getBusinessType()) || StringUtils.isEmpty((String)pushData.getBusinessId()) || StringUtils.isEmpty((String)pushData.getUserId())) {
            throw new IllegalArgumentException("\u63a8\u9001\u4e1a\u52a1\u6d88\u606f\u7f3a\u5c11\u6761\u4ef6\uff1abusinessType, businessId, userId");
        }
        String creator = this.getCurrentUserPrincipal() == null ? "creator" : this.getCurrentUserPrincipal().getId();
        Notification notification = new Notification();
        notification.setCreator(creator);
        notification.setCreateTime(DateUtils.getDateTimeNumber());
        notification.setFrom("platform");
        notification.setTitle(pushData.getTitle());
        notification.setOptionId(pushData.getBusinessId());
        notification.setOptionType(pushData.getBusinessType());
        notification.setContent(pushData.toJson());
        notification.setId(NumberGenerator.getLongSequenceId());
        ArrayList<String> receiverList = new ArrayList<String>(2);
        receiverList.add(pushData.getUserId());
        notification.setReceiverList(receiverList);
        ArrayList<NotificationChannel> channelList = new ArrayList<NotificationChannel>(4);
        for (String index : this.getPushManager().getMessageChannelNames()) {
            channelList.add(NotificationChannel.getType((String)index));
        }
        notification.setChannelList(channelList);
        notification.setParallel(this.getPushManager().isMessageParallel());
        this.getPushManager().push(notification, null);
    }
}

