/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base;

import com.iplatform.base.AbstractFileOperateSpiController;
import com.iplatform.base.AsyncManager;
import com.iplatform.base.DeptCacheProvider;
import com.iplatform.base.NotificationTemplateCache;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.UserLoginCache;
import com.iplatform.base.cache.DictCacheProvider;
import com.iplatform.base.di.PlatformDataImportEngine;
import com.iplatform.base.di.TemplateInfo;
import com.iplatform.base.service.DeptServiceImpl;
import com.iplatform.base.service.LogServiceImpl;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.support.strategy.LoginStrategyManager;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_dept;
import com.iplatform.model.po.S_dict_data;
import com.iplatform.model.po.S_oper_log;
import com.iplatform.model.po.S_user_core;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.FileCopyUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.PhoneNumberUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.PushManager;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.ResponseCode;
import com.walker.web.WebAgentService;
import com.walker.web.WebUserAgent;
import com.walker.web.log.BusinessType;
import com.walker.web.log.OperateUser;
import com.walker.web.util.IdUtils;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public abstract class SystemController
extends AbstractFileOperateSpiController {
    private CaptchaProvider<CaptchaResult> smsCaptchaProvider;
    private CacheProvider<String> captchaCacheProvider;
    private PushManager pushManager;
    private DeptCacheProvider deptCacheProvider;
    private UserCacheProvider userCacheProvider;
    private PlatformDataImportEngine platformDataImportEngine;
    private DictCacheProvider dictCacheProvider;

    protected UserLoginCache getUserLoginCache() {
        return (UserLoginCache)BeanContextAware.getBeanByType(UserLoginCache.class);
    }

    protected NotificationTemplateCache getNotificationTemplateCache() {
        return (NotificationTemplateCache)BeanContextAware.getBeanByType(NotificationTemplateCache.class);
    }

    protected void systemLogSuccess(String userName, OperateUser operateUser, BusinessType businessType, String title, String input, String output) {
        final S_oper_log s_oper_log = this.acquireSystemLog(userName, operateUser, businessType, title, input, output);
        AsyncManager.me().execute(new TimerTask(){

            @Override
            public void run() {
                ((LogServiceImpl)((Object)BeanContextAware.getBeanByType(LogServiceImpl.class))).execInsertOperateLog(s_oper_log);
            }
        });
    }

    protected void systemLogError(String userName, OperateUser operateUser, BusinessType businessType, String title, String input, String error) {
        if (StringUtils.isEmpty((String)error)) {
            this.logger.warn("\u8c03\u7528\u5199\u5165\u9519\u8bef\u65e5\u5fd7\uff0c\u4f46\u672a\u63d0\u4f9b\u9519\u8bef\u5185\u5bb9\uff0c\u65e5\u5fd7\u5c06\u4e0d\u4f1a\u4fdd\u5b58\uff1asystemLogError --> error is null!");
            return;
        }
        final S_oper_log s_oper_log = this.acquireSystemLog(userName, operateUser, businessType, title, input, null);
        s_oper_log.setStatus(ResponseCode.ERROR.getCode());
        s_oper_log.setError_msg(StringUtils.substring((String)error, (int)0, (int)255));
        AsyncManager.me().execute(new TimerTask(){

            @Override
            public void run() {
                ((LogServiceImpl)((Object)BeanContextAware.getBeanByType(LogServiceImpl.class))).execInsertOperateLog(s_oper_log);
            }
        });
    }

    private S_oper_log acquireSystemLog(String userName, OperateUser operateUser, BusinessType businessType, String title, String input, String output) {
        if (operateUser == null) {
            operateUser = OperateUser.Manage;
        }
        if (businessType == null) {
            businessType = BusinessType.Other;
        }
        WebUserAgent agent = this.getCurrentWebUserAgent();
        S_oper_log s_oper_log = new S_oper_log();
        s_oper_log.setOper_id(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        s_oper_log.setOper_time(Long.valueOf(DateUtils.getDateTimeNumber()));
        s_oper_log.setStatus(ResponseCode.SUCCESS.getCode());
        s_oper_log.setOper_name(userName);
        s_oper_log.setOperate_user(Integer.valueOf(operateUser.getIndex()));
        s_oper_log.setBusiness_type(Integer.valueOf(businessType.getIndex()));
        s_oper_log.setOper_ip(agent.getIp());
        s_oper_log.setOper_location(agent.getLocation());
        s_oper_log.setRequest_method(agent.getMethod());
        s_oper_log.setOper_url(agent.getUrl());
        s_oper_log.setTitle(title);
        if (StringUtils.isNotEmpty((String)input)) {
            s_oper_log.setOper_param(input);
        }
        if (StringUtils.isNotEmpty((String)output)) {
            s_oper_log.setJson_result(output);
        }
        return s_oper_log;
    }

    protected LoginStrategyManager getLoginStrategyManager() {
        return (LoginStrategyManager)BeanContextAware.getBeanByType(LoginStrategyManager.class);
    }

    protected WebUserAgent getCurrentWebUserAgent() {
        HttpServletRequest request = this.getRequest();
        return this.getWebAgentService().getWebUserAgent(request.getHeader("User-Agent"), request);
    }

    protected WebAgentService getWebAgentService() {
        return (WebAgentService)BeanContextAware.getBeanByType(WebAgentService.class);
    }

    protected boolean validateSmsCode(String code, String uuid) {
        CaptchaResult captchaResult = new CaptchaResult();
        captchaResult.setCode(code);
        captchaResult.setUuid(uuid);
        return this.smsCaptchaProvider.validateCaptcha((Object)captchaResult);
    }

    protected Map<String, Object> sendSmsCodeValidation(String phoneNumber) {
        if (!PhoneNumberUtils.isCellPhoneNumber((String)phoneNumber)) {
            throw new PlatformRuntimeException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef\uff1a" + phoneNumber);
        }
        String uuid = IdUtils.simpleUUID();
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("uuid", uuid);
        String verifyKey = "captcha_codes:" + uuid;
        CaptchaResult captchaResult = (CaptchaResult)this.smsCaptchaProvider.generateCaptcha((Object)phoneNumber);
        if (captchaResult == null) {
            throw new PlatformRuntimeException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u751f\u6210\u9519\u8bef, null");
        }
        this.captchaCacheProvider.putCacheData(verifyKey, (Object)captchaResult.getCode(), 120L);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u751f\u6210\u77ed\u4fe1\u9a8c\u8bc1\u7801:{}, uuid:{}", (Object)captchaResult.getCode(), (Object)uuid);
        }
        data.put("message", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001");
        return data;
    }

    protected long getOwner() {
        S_user_core user = this.getCurrentUser();
        int userType = user.getUser_type();
        if (userType == 0) {
            return -1L;
        }
        S_dept dept = this.getDept(user.getOrg_id());
        if (dept.getMenu_type() == 0) {
            return -1L;
        }
        return dept.getId();
    }

    protected int getCurrentOrgMenuScope() {
        long orgId = this.getCurrentUser().getOrg_id();
        if (orgId == 0L) {
            return 0;
        }
        return this.getDeptCacheProvider().getDept(orgId).getMenu_type();
    }

    protected String getDictName(long dictCode) {
        S_dict_data dict_data = (S_dict_data)this.getDictCacheProvider().getCacheData(String.valueOf(dictCode));
        if (dict_data == null) {
            throw new IllegalStateException("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u5b57\u5178\u540d\u79f0\uff0cdict_code = " + dictCode);
        }
        return dict_data.getDict_label();
    }

    protected String getDeptName(long deptId) {
        S_dept dept = this.getDept(deptId);
        return dept == null ? "None" : dept.getDept_name();
    }

    protected S_dept getDept(long deptId) {
        return this.getDeptCacheProvider().getDept(deptId);
    }

    public S_user_core getUser(long userId) {
        return this.getUserCacheProvider().getUser(userId);
    }

    protected void downloadLocalImportTemplate(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            throw new IllegalArgumentException("\u8bf7\u63d0\u4f9b\u8981\u5bfc\u5165\u6570\u636e\u7684'\u8868\u540d\u79f0'!");
        }
        String templatePath = this.acquireFileOperateSpi().getFileRootConfig();
        String templateFileName = "template_" + tableName + "_" + DateUtils.getDateTimeSecondForShow() + ".xlsx";
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setTemplatePath(templatePath + templateFileName);
        templateInfo.setTableName(tableName);
        this.logger.debug("templateInfo = {}", (Object)templateInfo);
        File templateFile = this.getDataImportEngine().generateTemplate(templateInfo);
        try {
            this.downloadSimpleFile(FileCopyUtils.copyToByteArray((File)templateFile), templateFileName);
        }
        catch (IOException e) {
            this.logger.error("\u4e0b\u8f7d\u6a21\u677f\u9519\u8bef:" + e.getMessage() + ", tableName=" + tableName, (Throwable)e);
            ServletUtils.renderString((HttpServletResponse)this.getResponse(), (String)("\u4e0b\u8f7d\u6a21\u677f\u9519\u8bef:" + e.getMessage() + ", tableName=" + tableName));
        }
    }

    protected DictCacheProvider getDictCacheProvider() {
        return this.dictCacheProvider;
    }

    protected PlatformDataImportEngine getDataImportEngine() {
        return this.platformDataImportEngine;
    }

    public UserCacheProvider getUserCacheProvider() {
        return this.userCacheProvider;
    }

    public DeptCacheProvider getDeptCacheProvider() {
        return this.deptCacheProvider;
    }

    protected long getUserRootOrgId(long userId) {
        this.checkUserCacheProvider();
        S_user_core user_core = this.userCacheProvider.getUser(userId);
        if (user_core == null) {
            throw new IllegalStateException("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u7528\u6237: " + userId);
        }
        return user_core.getOrg_id();
    }

    protected long getRootOrgIdByDept(long deptId) {
        if (this.deptCacheProvider == null) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8bbe\u7f6econtroller\u5bf9\u8c61: deptCacheProvider");
        }
        S_dept dept = this.deptCacheProvider.getDept(deptId);
        if (dept == null) {
            throw new IllegalStateException("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u673a\u6784: " + deptId);
        }
        return dept.getOrg_id();
    }

    protected List<S_dept> getOrgListScope() {
        DeptServiceImpl deptService = (DeptServiceImpl)((Object)BeanContextAware.getBeanByType(DeptServiceImpl.class));
        S_user_core currentUser = this.getCurrentUser();
        List<S_dept> list = null;
        list = currentUser.getUser_type() == 0 ? deptService.queryRootOrgList(0L) : deptService.queryRootOrgList(currentUser.getOrg_id());
        if (StringUtils.isEmptyList(list)) {
            list = new ArrayList<S_dept>(2);
            list.add(this.createDefaultOrg());
        }
        return list;
    }

    private void checkUserCacheProvider() {
        if (this.userCacheProvider == null) {
            throw new IllegalStateException("UserCacheProvider \u5fc5\u987b\u5148\u8bbe\u7f6e\u5230\u63a7\u5236\u5668\u4e2d\u3002");
        }
    }

    private S_dept createDefaultOrg() {
        S_dept root = new S_dept();
        root.setId(Long.valueOf(0L));
        root.setParent_id(Long.valueOf(0L));
        root.setOrg_type(Integer.valueOf(0));
        root.setOrder_num(Integer.valueOf(1));
        root.setDept_name("\u9ed8\u8ba4\u5355\u4f4d");
        return root;
    }

    public void setDeptCacheProvider(DeptCacheProvider deptCacheProvider) {
        this.deptCacheProvider = deptCacheProvider;
    }

    public void setUserCacheProvider(UserCacheProvider userCacheProvider) {
        this.userCacheProvider = userCacheProvider;
    }

    public void setPlatformDataImportEngine(PlatformDataImportEngine platformDataImportEngine) {
        this.platformDataImportEngine = platformDataImportEngine;
    }

    public void setDictCacheProvider(DictCacheProvider dictCacheProvider) {
        this.dictCacheProvider = dictCacheProvider;
    }

    public void setPushManager(PushManager pushManager) {
        this.pushManager = pushManager;
    }

    public void setSmsCaptchaProvider(CaptchaProvider<CaptchaResult> smsCaptchaProvider) {
        this.smsCaptchaProvider = smsCaptchaProvider;
    }

    public void setCaptchaCacheProvider(CacheProvider<String> captchaCacheProvider) {
        this.captchaCacheProvider = captchaCacheProvider;
    }

    public CaptchaProvider<CaptchaResult> getSmsCaptchaProvider() {
        return this.smsCaptchaProvider;
    }

    public CacheProvider<String> getCaptchaCacheProvider() {
        return this.captchaCacheProvider;
    }

    protected UserServiceImpl getUserService() {
        return (UserServiceImpl)((Object)BeanContextAware.getBeanByType(UserServiceImpl.class));
    }

    protected PushManager getPushManager() {
        return this.pushManager;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

