/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base;

import com.iplatform.base.ThirdPartyAuthentication;
import com.walker.infrastructure.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdPartyManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ThirdPartyAuthentication> authenticationMap = new ConcurrentHashMap<String, ThirdPartyAuthentication>(8);

    public void register(ThirdPartyAuthentication thirdPartyAuthentication) {
        if (thirdPartyAuthentication == null) {
            throw new IllegalArgumentException("\u6ce8\u518c\u7b2c\u4e09\u65b9\u8ba4\u8bc1\u5bf9\u8c61\u4e3a\u7a7a");
        }
        String key = thirdPartyAuthentication.getName();
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("\u81ea\u5b9a\u4e49\u7b2c\u4e09\u65b9\u8ba4\u8bc1\u5bf9\u8c61\u540d\u79f0\u4e0d\u5b58\u5728\uff1agetName()");
        }
        if (this.authenticationMap.get(key) != null) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u7b2c\u4e09\u65b9\u8ba4\u8bc1\u5b9a\u4e49:" + key);
        }
        this.authenticationMap.put(key, thirdPartyAuthentication);
        this.logger.info("\u6ce8\u518c'\u7b2c\u4e09\u65b9\u8ba4\u8bc1\u5bf9\u8c61' = " + key + ", " + thirdPartyAuthentication.getDescription());
    }

    public ThirdPartyAuthentication getThirdPartyAuthentication(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("\u8bf7\u63d0\u4f9b\u7b2c\u4e09\u65b9\u8ba4\u8bc1\u6807\u8bc6");
        }
        return this.authenticationMap.get(key);
    }
}

